/*
 * Decompiled with CFR 0.152.
 */
package com.thesledgehammer.retrobees.misc;

import forestry.core.blocks.IColoredBlock;
import forestry.core.items.IColoredItem;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.statemap.BlockStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ObjectManager {
    private static final Minecraft minecraft = Minecraft.func_71410_x();
    private static final Set<IColoredItem> itemColorList = new HashSet<IColoredItem>();
    private static final Set<IColoredBlock> blockColorList = new HashSet<IColoredBlock>();
    private static final Set<IStateMapper> stateMapperList = new HashSet<IStateMapper>();

    public static void ColorRegister() {
        ObjectManager.registerItemColor();
        ObjectManager.registerBlockColor();
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockClient(Block block) {
        if (block instanceof IColoredBlock) {
            blockColorList.add((IColoredBlock)block);
        }
        if (block instanceof IStateMapper) {
            stateMapperList.add((IStateMapper)block);
        }
        for (IStateMapper stateMapper : stateMapperList) {
            if (!(stateMapper instanceof BlockStateMapper)) continue;
            ((BlockStateMapper)stateMapper).func_178447_a(block, stateMapper);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemClient(Item item) {
        if (item instanceof IColoredItem) {
            itemColorList.add((IColoredItem)item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemColor() {
        ItemColors itemColors = minecraft.getItemColors();
        for (IColoredItem itemColor : itemColorList) {
            if (!(itemColor instanceof Item)) continue;
            itemColors.func_186730_a((IItemColor)ColoredItemItemColor.INSTANCE, new Item[]{(Item)itemColor});
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerBlockColor() {
        BlockColors blockColors = minecraft.func_184125_al();
        for (IColoredBlock blockColor : blockColorList) {
            if (!(blockColor instanceof Block)) continue;
            blockColors.func_186722_a((IBlockColor)ColoredBlockBlockColor.INSTANCE, new Block[]{(Block)blockColor});
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class ColoredBlockBlockColor
    implements IBlockColor {
        public static final ColoredBlockBlockColor INSTANCE = new ColoredBlockBlockColor();

        private ColoredBlockBlockColor() {
        }

        public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
            Block block = state.func_177230_c();
            if (block instanceof IColoredBlock && worldIn != null && pos != null) {
                return ((IColoredBlock)block).colorMultiplier(state, worldIn, pos, tintIndex);
            }
            return 0xFFFFFF;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class ColoredItemItemColor
    implements IItemColor {
        private static final ColoredItemItemColor INSTANCE = new ColoredItemItemColor();

        private ColoredItemItemColor() {
        }

        public int func_186726_a(ItemStack stack, int tintIndex) {
            Item item = stack.func_77973_b();
            if (item instanceof IColoredItem) {
                return ((IColoredItem)item).getColorFromItemstack(stack, tintIndex);
            }
            return 0xFFFFFF;
        }
    }
}

