/*
 * Decompiled with CFR 0.152.
 */
package me.pieking1215.invmove;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.function.Function;
import me.pieking1215.invmove.compat.Compatibility;
import me.pieking1215.invmove.compat.ModCompatibility;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@net.minecraftforge.common.config.Config(modid="invmove", category="")
@Mod.EventBusSubscriber
public class Config {
    @Config.LangKey(value="key.invmove.category.general")
    public static final General GENERAL = new General();
    @Config.LangKey(value="key.invmove.category.movement")
    public static final UIMovement UI_MOVEMENT = new UIMovement();
    @Config.LangKey(value="key.invmove.category.background")
    public static final UIBackground UI_BACKGROUND = new UIBackground();
    @Config.Ignore
    public static boolean hasFinalizedConfig = false;
    @Config.Ignore
    public static HashMap<String, File> modCompatConfigs;
    @Config.Ignore
    public static Function<Boolean, String> movement_yesNoText;
    @Config.Ignore
    public static Function<Boolean, String> background_yesNoText;

    public static void doneLoading() {
        hasFinalizedConfig = true;
        modCompatConfigs = new HashMap();
        File dotMinecraft = Minecraft.func_71410_x().field_71412_D;
        for (String modid : Compatibility.getCompatibilities().keySet()) {
            try {
                File f = new File(dotMinecraft, "config/invMove_1_12/" + modid + ".json");
                f.getParentFile().mkdirs();
                if (!f.exists()) {
                    f.createNewFile();
                }
                modCompatConfigs.put(modid, f);
                JsonReader jr = new JsonReader((Reader)new FileReader(f));
                JsonElement jp = new JsonParser().parse(jr);
                if (jp.isJsonObject()) {
                    JsonObject obj = jp.getAsJsonObject();
                    Compatibility.getCompatibilities().get(modid).loadConfig(obj);
                }
                jr.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("invmove")) {
            ConfigManager.sync((String)"invmove", (Config.Type)Config.Type.INSTANCE);
            for (String modid : modCompatConfigs.keySet()) {
                ModCompatibility compat;
                File f = modCompatConfigs.get(modid);
                if (f == null || (compat = Compatibility.getCompatibilities().get(modid)) == null) continue;
                try {
                    f.getParentFile().mkdirs();
                    if (!f.exists()) {
                        f.createNewFile();
                    }
                    JsonWriter jw = new JsonWriter((Writer)new FileWriter(f));
                    jw.setIndent("  ");
                    jw.beginObject();
                    compat.saveConfig(jw);
                    jw.endObject();
                    jw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        movement_yesNoText = b -> b != false ? TextFormatting.GREEN + "Allow Movement" : TextFormatting.RED + "Disallow Movement";
        background_yesNoText = b -> b != false ? TextFormatting.GREEN + "Hide Background" : TextFormatting.RED + "Show Background";
    }

    public static class UIMovement {
        @Config.LangKey(value="config.invmove.movement.enable")
        public boolean moveInInventories = true;
        @Config.LangKey(value="config.invmove.movement.sneak")
        public boolean sneakInInventories = false;
        @Config.LangKey(value="config.invmove.movement.jump")
        public boolean jumpInInventories = true;
        @Config.LangKey(value="config.invmove.movement.textFieldDisables")
        public boolean textFieldDisablesMovement = true;
        @Config.LangKey(value="key.invmove.category.types")
        public MovementVanillaTypes VANILLA = new MovementVanillaTypes();
        @Config.LangKey(value="key.invmove.category.types.unrecognized")
        public HashMap<String, Boolean> seenScreens = new HashMap();

        class MovementVanillaTypes {
            @Config.LangKey(value="config.invmove.type.inventory")
            public boolean inventory = true;
            @Config.LangKey(value="config.invmove.type.creative")
            public boolean creative = true;
            @Config.LangKey(value="config.invmove.type.crafting")
            public boolean crafting = true;
            @Config.LangKey(value="config.invmove.type.chest")
            public boolean chest = true;
            @Config.LangKey(value="config.invmove.type.shulker")
            public boolean shulker = true;
            @Config.LangKey(value="config.invmove.type.dispenser")
            public boolean dispenser = true;
            @Config.LangKey(value="config.invmove.type.hopper")
            public boolean hopper = true;
            @Config.LangKey(value="config.invmove.type.enchantment")
            public boolean enchantment = true;
            @Config.LangKey(value="config.invmove.type.anvil")
            public boolean anvil = true;
            @Config.LangKey(value="config.invmove.type.beacon")
            public boolean beacon = true;
            @Config.LangKey(value="config.invmove.type.brewing")
            public boolean brewing = true;
            @Config.LangKey(value="config.invmove.type.furnace")
            public boolean furnace = true;
            @Config.LangKey(value="config.invmove.type.villager")
            public boolean villager = true;

            MovementVanillaTypes() {
            }
        }
    }

    public static class UIBackground {
        @Config.LangKey(value="config.invmove.background.enable")
        public boolean uiBackground = true;
        @Config.LangKey(value="key.invmove.category.types")
        public BackgroundVanillaTypes VANILLA = new BackgroundVanillaTypes();
        @Config.LangKey(value="key.invmove.category.types.unrecognized")
        public HashMap<String, Boolean> seenScreens = new HashMap();

        class BackgroundVanillaTypes {
            @Config.LangKey(value="config.invmove.type.inventory")
            public boolean inventory = false;
            @Config.LangKey(value="config.invmove.type.creative")
            public boolean creative = false;
            @Config.LangKey(value="config.invmove.type.crafting")
            public boolean crafting = false;
            @Config.LangKey(value="config.invmove.type.chest")
            public boolean chest = false;
            @Config.LangKey(value="config.invmove.type.shulker")
            public boolean shulker = false;
            @Config.LangKey(value="config.invmove.type.dispenser")
            public boolean dispenser = false;
            @Config.LangKey(value="config.invmove.type.hopper")
            public boolean hopper = false;
            @Config.LangKey(value="config.invmove.type.enchantment")
            public boolean enchantment = false;
            @Config.LangKey(value="config.invmove.type.anvil")
            public boolean anvil = false;
            @Config.LangKey(value="config.invmove.type.beacon")
            public boolean beacon = false;
            @Config.LangKey(value="config.invmove.type.brewing")
            public boolean brewing = false;
            @Config.LangKey(value="config.invmove.type.furnace")
            public boolean furnace = false;
            @Config.LangKey(value="config.invmove.type.villager")
            public boolean villager = false;

            BackgroundVanillaTypes() {
            }
        }
    }

    public static class General {
        @Config.LangKey(value="config.invmove.enable")
        public boolean enabled = true;
        @Config.LangKey(value="config.invmove.debugDisplay")
        public boolean debugDisplay = false;
    }
}

