/*
 * Decompiled with CFR 0.152.
 */
package me.pieking1215.invmove.compat;

import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;

public abstract class ModCompatibility {
    public List<BoolOption> movementOptions = new ArrayList<BoolOption>();
    public List<BoolOption> backgroundOptions = new ArrayList<BoolOption>();
    public ConfigCategory movementCategory;
    public ConfigCategory backgroundCategory;

    abstract Optional<Boolean> shouldAllowMovement(GuiScreen var1);

    abstract Optional<Boolean> shouldDisableBackground(GuiScreen var1);

    public boolean setupConfigMovement(ConfigCategory category) {
        this.movementCategory = category;
        if (this.movementOptions.isEmpty()) {
            return false;
        }
        for (BoolOption opt : this.movementOptions) {
            CallbackProperty testProp = new CallbackProperty(opt.displayName, opt.bool.get() + "", Property.Type.BOOLEAN);
            testProp.callback = s -> opt.bool.set(s.equals("true"));
            testProp.setDefaultValue(opt.defaultState);
            testProp.setComment(opt.tooltip);
            category.put(opt.displayName, (Property)testProp);
        }
        return true;
    }

    public boolean setupConfigBackground(ConfigCategory category) {
        this.backgroundCategory = category;
        if (this.backgroundOptions.isEmpty()) {
            return false;
        }
        for (BoolOption opt : this.backgroundOptions) {
            CallbackProperty testProp = new CallbackProperty(opt.displayName, opt.bool.get() + "", Property.Type.BOOLEAN);
            testProp.callback = s -> opt.bool.set(s.equals("true"));
            testProp.setDefaultValue(opt.defaultState);
            testProp.setComment(opt.tooltip);
            category.put(opt.displayName, (Property)testProp);
        }
        return true;
    }

    public void loadConfig(JsonObject obj) {
        System.out.println("LOADING COMPAT: " + this.getClass().getSimpleName());
        for (BoolOption opt : this.movementOptions) {
            System.out.println(opt.optionID + " " + obj.has(opt.optionID));
            if (!obj.has(opt.optionID)) continue;
            opt.bool.set(obj.get(opt.optionID).getAsBoolean());
        }
        for (BoolOption opt : this.backgroundOptions) {
            if (!obj.has(opt.optionID)) continue;
            opt.bool.set(obj.get(opt.optionID).getAsBoolean());
        }
    }

    public void saveConfig(JsonWriter jw) throws IOException {
        for (BoolOption opt : this.movementOptions) {
            jw.name(opt.optionID).value(opt.bool.get());
        }
        for (BoolOption opt : this.backgroundOptions) {
            jw.name(opt.optionID).value(opt.bool.get());
        }
    }

    public static class CallbackProperty
    extends Property {
        Callback callback;

        public CallbackProperty(String name, String value, Property.Type type) {
            super(name, value, type);
        }

        public CallbackProperty(String name, String value, Property.Type type, boolean read) {
            super(name, value, type, read);
        }

        public CallbackProperty(String name, String value, Property.Type type, String[] validValues) {
            super(name, value, type, validValues);
        }

        public CallbackProperty(String name, String value, Property.Type type, String[] validValues, String[] validValuesDisplay) {
            super(name, value, type, validValues, validValuesDisplay);
        }

        public CallbackProperty(String name, String value, Property.Type type, String langKey) {
            super(name, value, type, langKey);
        }

        public CallbackProperty(String name, String value, Property.Type type, boolean read, String langKey) {
            super(name, value, type, read, langKey);
        }

        public CallbackProperty(String name, String value, Property.Type type, String[] validValues, String langKey) {
            super(name, value, type, validValues, langKey);
        }

        public CallbackProperty(String name, String value, Property.Type type, String[] validValues, String[] validValuesDisplay, String langKey) {
            super(name, value, type, validValues, validValuesDisplay, langKey);
        }

        public CallbackProperty(String name, String[] values, Property.Type type) {
            super(name, values, type);
        }

        public CallbackProperty(String name, String[] values, Property.Type type, String langKey) {
            super(name, values, type, langKey);
        }

        public Property setValue(String value) {
            if (this.callback != null) {
                this.callback.onValueChanged(value);
            }
            return super.setValue(value);
        }

        public static interface Callback {
            public void onValueChanged(String var1);
        }
    }

    public class BoolOption {
        String displayName;
        String optionID;
        AtomicBoolean bool;
        boolean defaultState;
        String tooltip;

        public BoolOption(String displayName, String optionID, AtomicBoolean bool, boolean defaultState, String tooltip) {
            this.displayName = displayName;
            this.optionID = optionID;
            this.bool = bool;
            this.defaultState = defaultState;
            this.tooltip = tooltip;
        }

        public BoolOption(String displayName, String optionID, AtomicBoolean bool, boolean defaultState) {
            this(displayName, optionID, bool, defaultState, null);
        }
    }
}

