/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot.pattern.parameter;

import buildcraft.api.core.render.ISprite;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.builders.BCBuildersSprites;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.StackUtil;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public enum PatternParameterAxis implements IStatementParameter
{
    X(EnumFacing.Axis.X),
    Y(EnumFacing.Axis.Y),
    Z(EnumFacing.Axis.Z);

    public final EnumFacing.Axis axis;

    private PatternParameterAxis(EnumFacing.Axis axis) {
        this.axis = axis;
    }

    public static PatternParameterAxis readFromNbt(NBTTagCompound nbt) {
        byte ord = nbt.func_74771_c("a");
        if (ord <= 0) {
            return X;
        }
        if (ord >= 2) {
            return Z;
        }
        return Y;
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:filler_parameter_axis";
    }

    @Override
    public String getDescription() {
        return LocaleUtil.localize("buildcraft.param.axis." + this.name().toLowerCase(Locale.ROOT));
    }

    @Override
    public ISprite getSprite() {
        return BCBuildersSprites.PARAM_AXIS.get(this.axis);
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        return StackUtil.EMPTY;
    }

    @Override
    public IStatementParameter onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        return null;
    }

    @Override
    public void writeToNbt(NBTTagCompound nbt) {
        nbt.func_74774_a("a", (byte)this.ordinal());
    }

    @Override
    public IStatementParameter rotateLeft() {
        switch (this) {
            case X: {
                return Z;
            }
            case Y: {
                return Y;
            }
            case Z: {
                return X;
            }
        }
        throw new IllegalStateException("Unknown axis " + this);
    }

    @Override
    public IStatementParameter[] getPossible(IStatementContainer source) {
        return PatternParameterAxis.values();
    }
}

