/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.font;

import buildcraft.lib.client.guide.font.IFontRenderer;
import buildcraft.lib.client.sprite.DynamicTextureBC;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.lib.misc.RenderUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;

public class GuideFont
implements IFontRenderer {
    private final DynamicTextureBC tex = new DynamicTextureBC(512, 512);
    private final BufferedImage img;
    private final Graphics2D g2d;
    private final Font font;

    public GuideFont(Font font) {
        this.font = font;
        this.img = new BufferedImage(512, 512, 2);
        this.g2d = this.img.createGraphics();
    }

    @Override
    public int getStringWidth(String text) {
        FontMetrics metrics = this.g2d.getFontMetrics(this.font);
        Rectangle2D rect = metrics.getStringBounds(text, this.g2d);
        return (int)rect.getWidth();
    }

    @Override
    public int getFontHeight(String text) {
        FontMetrics metrics = this.g2d.getFontMetrics(this.font);
        Rectangle2D rect = metrics.getStringBounds(text, this.g2d);
        return (int)rect.getHeight();
    }

    @Override
    public int getMaxFontHeight() {
        return this.g2d.getFontMetrics().getMaxAscent() + this.g2d.getFontMetrics().getMaxDescent();
    }

    @Override
    public int drawString(String text, int x, int y, int shade, boolean shadow, boolean centered, float scale) {
        text = ColourUtil.stripAllFormatCodes(text);
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc);
        double scaleFactor = (double)mc.field_71443_c / res.func_78327_c();
        this.g2d.setColor(new Color(0, 0, 0, 255));
        this.g2d.fillRect(0, 0, 512, 512);
        this.g2d.setColor(new Color(0xFFFFFF));
        Font f2 = this.font.deriveFont(this.font.getSize2D() * scale * (float)scaleFactor);
        if (shadow) {
            f2 = f2.deriveFont(1);
        }
        FontMetrics metrics = this.g2d.getFontMetrics(f2);
        this.g2d.setFont(f2);
        Rectangle2D rect = metrics.getStringBounds(text, this.g2d);
        int font_height = metrics.getMaxAscent() + metrics.getMaxDescent();
        this.g2d.drawString(text, 0, metrics.getMaxAscent());
        for (int _x = 0; _x < 512; ++_x) {
            for (int _y = 0; _y <= font_height; ++_y) {
                int rgb = this.img.getRGB(_x, _y);
                if ((rgb & 0xFF) == 0) {
                    rgb = 0;
                }
                this.tex.setColor(_x, _y, rgb);
            }
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)(1.0 / scaleFactor), (double)(1.0 / scaleFactor), (double)1.0);
        if ((shade & 0xFF000000) == 0) {
            shade |= 0xFF000000;
        }
        RenderUtil.setGLColorFromIntPlusAlpha(shade);
        if (centered) {
            x = (int)((double)x - rect.getWidth() / 2.0 / scaleFactor);
        }
        this.tex.draw((int)((double)x * scaleFactor), (int)((double)y * scaleFactor - (double)metrics.getMaxDescent()), 0.0f, 0, 0, (int)rect.getWidth(), (int)(rect.getHeight() + 1.0));
        GlStateManager.func_179121_F();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
        return (int)rect.getWidth();
    }

    @Override
    public List<String> wrapString(String text, int maxWidth, boolean shadow, float scale) {
        FontState state = new FontState(this, scale, shadow);
        return Collections.singletonList(text);
    }

    private static class FontState {
        final FontMetrics[] metrics = new FontMetrics[4];
        final boolean defaultShadow;

        FontState(GuideFont font, float scale, boolean shadow) {
            this.defaultShadow = shadow;
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution res = new ScaledResolution(mc);
            double scaleFactor = (double)mc.field_71443_c / res.func_78327_c();
            Font f2 = font.font.deriveFont(font.font.getSize2D() * scale * (float)scaleFactor);
            for (int i : new int[]{0, 1, 2, 3}) {
                this.metrics[i] = font.g2d.getFontMetrics(f2.deriveFont(i));
            }
        }

        public int getPixelWidth(String text) {
            return 0;
        }
    }
}

