/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.node;

import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.text.TextFormatting;

public final class FormatSegment {
    public final String text;
    public final TextFormatting colour;
    public final Set<TextFormatting> misc;

    FormatSegment(String text, TextFormatting colour, Set<TextFormatting> misc) {
        this.text = text;
        this.colour = colour;
        this.misc = misc;
    }

    @Nullable
    public FormatSegment join(FormatSegment other) {
        if (this.colour == other.colour && this.misc.equals(other.misc)) {
            return new FormatSegment(this.text + other.text, this.colour, this.misc);
        }
        return null;
    }

    public String toFormatString() {
        StringBuilder miscString = new StringBuilder();
        for (TextFormatting format : this.misc) {
            miscString.append(format.toString());
        }
        return TextFormatting.RESET + (this.colour == null ? "" : this.colour.toString()) + miscString + this.text;
    }

    public String toString() {
        StringBuilder miscStr = new StringBuilder();
        for (TextFormatting format : this.misc) {
            miscStr.append(format.func_96297_d());
            miscStr.append(' ');
        }
        return (this.colour == null ? "" : this.colour.func_96297_d() + "") + miscStr + this.text;
    }
}

