/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.api;

import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.VecDouble;
import buildcraft.lib.expression.VecLong;
import buildcraft.lib.expression.api.IConstantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeType;
import buildcraft.lib.expression.node.cast.NodeCasting;
import buildcraft.lib.expression.node.func.NodeFuncDoubleDoubleToBoolean;
import buildcraft.lib.expression.node.func.NodeFuncDoubleDoubleToDouble;
import buildcraft.lib.expression.node.func.NodeFuncDoubleToDouble;
import buildcraft.lib.expression.node.func.NodeFuncLongLongToBoolean;
import buildcraft.lib.expression.node.func.NodeFuncLongLongToLong;
import buildcraft.lib.expression.node.func.NodeFuncLongToDouble;
import buildcraft.lib.expression.node.func.NodeFuncLongToLong;
import buildcraft.lib.expression.node.func.NodeFuncLongToObject;
import buildcraft.lib.expression.node.value.NodeConstantBoolean;
import buildcraft.lib.expression.node.value.NodeConstantDouble;
import buildcraft.lib.expression.node.value.NodeConstantLong;
import buildcraft.lib.expression.node.value.NodeConstantObject;
import buildcraft.lib.expression.node.value.NodeVariable;
import buildcraft.lib.expression.node.value.NodeVariableBoolean;
import buildcraft.lib.expression.node.value.NodeVariableDouble;
import buildcraft.lib.expression.node.value.NodeVariableLong;
import buildcraft.lib.expression.node.value.NodeVariableObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class NodeTypes {
    public static final FunctionContext LONG = LongFunctions.LONG;
    public static final FunctionContext DOUBLE = DoubleFunctions.DOUBLE;
    public static final FunctionContext BOOLEAN;
    public static final NodeType<String> STRING;
    public static final NodeType<VecLong> VEC_LONG;
    public static final NodeType<VecDouble> VEC_DOUBLE;
    public static final NodeType<IExpressionNode.INodeLong> NODE_LONG;
    public static final NodeType<IExpressionNode.INodeDouble> NODE_DOUBLE;
    public static final NodeType<IExpressionNode.INodeBoolean> NODE_BOOLEAN;
    private static final Map<String, Class<?>> typesByName;
    private static final Map<Class<?>, String> namesByType;
    public static final Map<Class<?>, NodeType<?>> typesByClass;

    private static String functionCharAt(String str, long index) {
        return NodeTypes.functionSubstringRelative(str, index, 1L);
    }

    private static String functionSubstring(String str, long indexStart, long indexEnd) {
        if (indexStart >= indexEnd) {
            return "";
        }
        if (indexStart < 0L) {
            return "";
        }
        if (indexEnd >= (long)str.length()) {
            return "";
        }
        return str.substring((int)indexStart, (int)indexEnd);
    }

    private static String functionSubstringRelative(String str, long indexStart, long length) {
        return NodeTypes.functionSubstring(str, indexStart, indexStart + length);
    }

    public static Class<?> getType(String name) {
        return typesByName.get(name.toLowerCase(Locale.ROOT));
    }

    public static Class<?> parseType(String type) throws InvalidExpressionException {
        Class<?> clazz = NodeTypes.getType(type);
        if (clazz != null) {
            return clazz;
        }
        throw new InvalidExpressionException("Unknown type " + type + ", must be one of " + typesByName.keySet());
    }

    public static <T> NodeType<T> getType(Class<T> clazz) {
        return typesByClass.get(clazz);
    }

    public static String getName(Class<?> clazz) {
        return namesByType.get(clazz);
    }

    public static Collection<String> getValidTypeNames() {
        return typesByName.keySet();
    }

    public static FunctionContext getContext(Class<?> clazz) {
        if (clazz == Long.TYPE) {
            return LONG;
        }
        if (clazz == Double.TYPE) {
            return DOUBLE;
        }
        if (clazz == Boolean.TYPE) {
            return BOOLEAN;
        }
        return typesByClass.get(clazz);
    }

    public static <T> void addType(NodeType<T> type) {
        NodeTypes.addType(type.name, type);
    }

    public static <T> void addType(String key, NodeType<T> type) {
        key = key.toLowerCase(Locale.ROOT);
        namesByType.put(type.type, key);
        typesByName.put(key, type.type);
        typesByClass.put(type.type, type);
    }

    public static Class<?> getType(IExpressionNode node) {
        if (node instanceof IExpressionNode.INodeObject) {
            return ((IExpressionNode.INodeObject)node).getType();
        }
        if (node instanceof IExpressionNode.INodeLong) {
            return Long.TYPE;
        }
        if (node instanceof IExpressionNode.INodeDouble) {
            return Double.TYPE;
        }
        if (node instanceof IExpressionNode.INodeBoolean) {
            return Boolean.TYPE;
        }
        throw new IllegalArgumentException("Illegal node " + node.getClass());
    }

    public static Class<?> getType(INodeFunc node) {
        if (node instanceof INodeFunc.INodeFuncObject) {
            return ((INodeFunc.INodeFuncObject)node).getType();
        }
        if (node instanceof INodeFunc.INodeFuncLong) {
            return Long.TYPE;
        }
        if (node instanceof INodeFunc.INodeFuncDouble) {
            return Double.TYPE;
        }
        if (node instanceof INodeFunc.INodeFuncBoolean) {
            return Boolean.TYPE;
        }
        throw new IllegalArgumentException("Illegal node " + node.getClass());
    }

    public static NodeVariable makeVariableNode(Class<?> type, String name) {
        if (type == Long.TYPE) {
            return new NodeVariableLong(name);
        }
        if (type == Double.TYPE) {
            return new NodeVariableDouble(name);
        }
        if (type == Boolean.TYPE) {
            return new NodeVariableBoolean(name);
        }
        return new NodeVariableObject(name, type);
    }

    public static IConstantNode createConstantNode(IExpressionNode node) {
        if (node instanceof IExpressionNode.INodeLong) {
            return new NodeConstantLong(((IExpressionNode.INodeLong)node).evaluate());
        }
        if (node instanceof IExpressionNode.INodeDouble) {
            return new NodeConstantDouble(((IExpressionNode.INodeDouble)node).evaluate());
        }
        if (node instanceof IExpressionNode.INodeBoolean) {
            return NodeConstantBoolean.of(((IExpressionNode.INodeBoolean)node).evaluate());
        }
        if (node instanceof IExpressionNode.INodeObject) {
            IExpressionNode.INodeObject nodeObj = (IExpressionNode.INodeObject)node;
            return NodeTypes.createConstantObject(nodeObj);
        }
        throw new IllegalArgumentException("Illegal node " + node.getClass());
    }

    private static <T> IConstantNode createConstantObject(IExpressionNode.INodeObject<T> nodeObj) {
        return new NodeConstantObject<T>(nodeObj.getType(), nodeObj.evaluate());
    }

    public static IExpressionNode cast(IExpressionNode node, Class<?> to) throws InvalidExpressionException {
        if (to == Double.TYPE) {
            return NodeCasting.castToDouble(node);
        }
        if (to == String.class) {
            return NodeCasting.castToString(node);
        }
        if (to == Long.TYPE) {
            if (node instanceof IExpressionNode.INodeLong) {
                return node;
            }
            throw new InvalidExpressionException("Cannot cast " + NodeTypes.getType(node) + " to a long");
        }
        if (to == Boolean.TYPE) {
            if (node instanceof IExpressionNode.INodeBoolean) {
                return node;
            }
            throw new InvalidExpressionException("Cannot cast " + NodeTypes.getType(node) + " to a boolean");
        }
        throw new IllegalStateException("Unknown node type '" + to + "'");
    }

    static {
        typesByName = new HashMap();
        namesByType = new HashMap();
        typesByClass = new HashMap();
        BOOLEAN = new FunctionContext("Type: Boolean");
        STRING = new NodeType<String>("String", "");
        VEC_LONG = new NodeType<VecLong>("Long Vector", VecLong.ZERO);
        VEC_DOUBLE = new NodeType<VecDouble>("Double Vector", VecDouble.ZERO);
        NODE_LONG = new NodeType<NodeConstantLong>("Long Node", IExpressionNode.INodeLong.class, NodeConstantLong.ZERO);
        NODE_DOUBLE = new NodeType<NodeConstantDouble>("Double Node", IExpressionNode.INodeDouble.class, NodeConstantDouble.ZERO);
        NODE_BOOLEAN = new NodeType<NodeConstantBoolean>("Boolean Node", IExpressionNode.INodeBoolean.class, NodeConstantBoolean.FALSE);
        typesByName.put("long", Long.TYPE);
        typesByName.put("double", Double.TYPE);
        typesByName.put("boolean", Boolean.TYPE);
        namesByType.put(Long.TYPE, "long");
        namesByType.put(Double.TYPE, "double");
        namesByType.put(Boolean.TYPE, "boolean");
        NodeTypes.addType("String", STRING);
        NodeTypes.addType("VecLong", VEC_LONG);
        NodeTypes.addType("VecDouble", VEC_DOUBLE);
        NodeTypes.addType("NodeLong", NODE_LONG);
        NodeTypes.addType("NodeDouble", NODE_DOUBLE);
        NodeTypes.addType("NodeBoolean", NODE_BOOLEAN);
        BOOLEAN.put_b_b("!", a -> !a, a -> "!" + a);
        BOOLEAN.put_bb_b("^", (a, b) -> a ^ b, (a, b) -> "(" + a + "^" + b + ")");
        BOOLEAN.put_bb_b("&", (a, b) -> a & b, (a, b) -> "(" + a + "&" + b + ")");
        BOOLEAN.put_bb_b("|", (a, b) -> a | b, (a, b) -> "(" + a + "|" + b + ")");
        BOOLEAN.put_bb_b("&&", (a, b) -> a && b, (a, b) -> "(" + a + "&&" + b + ")");
        BOOLEAN.put_bb_b("||", (a, b) -> a || b, (a, b) -> "(" + a + "||" + b + ")");
        BOOLEAN.put_bb_b("==", (a, b) -> a == b, (a, b) -> "(" + a + "==" + b + ")");
        BOOLEAN.put_bb_b("!=", (a, b) -> a != b, (a, b) -> "(" + a + "!=" + b + ")");
        BOOLEAN.put_b_o("(string)", String.class, a -> "" + a, a -> "((string) " + a + ")");
        STRING.put_tt_t("+", (a, b) -> a + b, (a, b) -> "(" + a + " + " + b + ")");
        STRING.put_tt_t("&", (a, b) -> a + b, (a, b) -> "(" + a + " + " + b + ")");
        STRING.put_tt_b("<", (a, b) -> a.compareTo((String)b) < 0, (a, b) -> "(" + a + " < " + b + ")");
        STRING.put_tt_b(">", (a, b) -> a.compareTo((String)b) > 0, (a, b) -> "(" + a + " > " + b + ")");
        STRING.put_tt_b("==", (a, b) -> Objects.equals(a, b), (a, b) -> "(" + a + " == " + b + ")");
        STRING.put_tt_b("!=", (a, b) -> !Objects.equals(a, b), (a, b) -> "(" + a + " != " + b + ")");
        STRING.put_tt_b("<=", (a, b) -> a.compareTo((String)b) <= 0, (a, b) -> "(" + a + " <= " + b + ")");
        STRING.put_tt_b(">=", (a, b) -> a.compareTo((String)b) >= 0, (a, b) -> "(" + a + " >= " + b + ")");
        STRING.put_t_l("length", String::length, a -> a + ".length()");
        STRING.put_t_t("toLowerCase", a -> a.toLowerCase(Locale.ROOT), a -> a + ".toLowerCase()");
        STRING.put_t_t("toUpperCase", a -> a.toUpperCase(Locale.ROOT), a -> a + ".toUpperCase()");
        STRING.put_tl_t("char_at", NodeTypes::functionCharAt);
        STRING.put_tll_t("substring", NodeTypes::functionSubstring);
        STRING.put_tll_t("substring_rel", NodeTypes::functionSubstringRelative);
        VEC_LONG.putConstant("ZERO", VecLong.ZERO);
        VEC_LONG.put_l_t("vec", VecLong::new);
        VEC_LONG.put_ll_t("vec", VecLong::new);
        VEC_LONG.put_lll_t("vec", VecLong::new);
        VEC_LONG.put_llll_t("vec", VecLong::new);
        VEC_LONG.put_t_o("(VecDouble)", VecDouble.class, VecLong::castToDouble);
        VEC_LONG.put_tt_t("+", VecLong::add);
        VEC_LONG.put_tt_t("-", VecLong::sub);
        VEC_LONG.put_tt_t("*", VecLong::scale);
        VEC_LONG.put_tt_t("/", VecLong::div);
        VEC_LONG.put_tt_t("cross", VecLong::crossProduct);
        VEC_LONG.put_tt_d("distanceTo", VecLong::distance);
        VEC_LONG.put_tt_l("dot2", VecLong::dotProduct2);
        VEC_LONG.put_tt_l("dot3", VecLong::dotProduct3);
        VEC_LONG.put_tt_l("dot4", VecLong::dotProduct4);
        VEC_LONG.put_t_d("length", VecLong::length);
        VEC_LONG.put_t_o("(string)", String.class, VecLong::toString);
        VEC_DOUBLE.put_d_t("vec", VecDouble::new);
        VEC_DOUBLE.put_dd_t("vec", VecDouble::new);
        VEC_DOUBLE.put_ddd_t("vec", VecDouble::new);
        VEC_DOUBLE.put_dddd_t("vec", VecDouble::new);
        VEC_DOUBLE.put_tt_t("+", VecDouble::add);
        VEC_DOUBLE.put_tt_t("-", VecDouble::sub);
        VEC_DOUBLE.put_tt_t("*", VecDouble::scale);
        VEC_DOUBLE.put_tt_t("/", VecDouble::div);
        VEC_DOUBLE.put_tt_t("cross", VecDouble::crossProduct);
        VEC_DOUBLE.put_tt_d("distanceTo", VecDouble::distance);
        VEC_DOUBLE.put_tt_d("dot2", VecDouble::dotProduct2);
        VEC_DOUBLE.put_tt_d("dot3", VecDouble::dotProduct3);
        VEC_DOUBLE.put_tt_d("dot4", VecDouble::dotProduct4);
        VEC_DOUBLE.put_t_d("length", VecDouble::length);
        VEC_DOUBLE.put_t_o("(string)", String.class, Object::toString);
    }

    public static class DoubleFunctions {
        public static final FunctionContext DOUBLE = new FunctionContext("Type: Double");
        public static final NodeFuncDoubleToDouble NEGATE = DOUBLE.put_d_d("-", a -> -a, a -> "-(" + a + ")");
        public static final NodeFuncDoubleDoubleToDouble ADD = DOUBLE.put_dd_d("+", (a, b) -> a + b, (a, b) -> "(" + a + " + " + b + ")");
        public static final NodeFuncDoubleDoubleToDouble SUB = DOUBLE.put_dd_d("-", (a, b) -> a - b, (a, b) -> "(" + a + " - " + b + ")");
        public static final NodeFuncDoubleDoubleToDouble MUL = DOUBLE.put_dd_d("*", (a, b) -> a * b, (a, b) -> "(" + a + " * " + b + ")");
        public static final NodeFuncDoubleDoubleToDouble DIV = DOUBLE.put_dd_d("/", (a, b) -> a / b, (a, b) -> "(" + a + " / " + b + ")");
        public static final NodeFuncDoubleDoubleToDouble MOD = DOUBLE.put_dd_d("%", (a, b) -> a % b, (a, b) -> "(" + a + " % " + b + ")");
        public static NodeFuncDoubleDoubleToBoolean LT = DOUBLE.put_dd_b("<", (a, b) -> a < b, (a, b) -> "(" + a + " < " + b + ")");
        public static NodeFuncDoubleDoubleToBoolean GT = DOUBLE.put_dd_b(">", (a, b) -> a > b, (a, b) -> "(" + a + " > " + b + ")");
        public static NodeFuncDoubleDoubleToBoolean LE = DOUBLE.put_dd_b("<=", (a, b) -> a <= b, (a, b) -> "(" + a + " <= " + b + ")");
        public static NodeFuncDoubleDoubleToBoolean GE = DOUBLE.put_dd_b(">=", (a, b) -> a >= b, (a, b) -> "(" + a + " >= " + b + ")");
        public static NodeFuncDoubleDoubleToBoolean EQ = DOUBLE.put_dd_b("==", (a, b) -> a == b, (a, b) -> "(" + a + " == " + b + ")");
        public static NodeFuncDoubleDoubleToBoolean NE = DOUBLE.put_dd_b("!=", (a, b) -> a != b, (a, b) -> "(" + a + " != " + b + ")");
        public static NodeFuncLongToObject<String> CVT_STRING = DOUBLE.put_l_o("(string)", String.class, a -> "" + a, a -> "((string) " + a + ")");
    }

    public static class LongFunctions {
        public static final FunctionContext LONG = new FunctionContext("Type: Long");
        public static final NodeFuncLongToLong NEGATE = LONG.put_l_l("-", a -> -a, a -> "-(" + a + ")");
        public static final NodeFuncLongToLong BITWISE_INVERT = LONG.put_l_l("~", a -> a ^ 0xFFFFFFFFFFFFFFFFL, a -> "~(" + a + ")");
        public static final NodeFuncLongLongToLong ADD = LONG.put_ll_l("+", (a, b) -> a + b, (a, b) -> "(" + a + " + " + b + ")");
        public static final NodeFuncLongLongToLong SUB = LONG.put_ll_l("-", (a, b) -> a - b, (a, b) -> "(" + a + " - " + b + ")");
        public static final NodeFuncLongLongToLong MUL = LONG.put_ll_l("*", (a, b) -> a * b, (a, b) -> "(" + a + " * " + b + ")");
        public static final NodeFuncLongLongToLong DIV = LONG.put_ll_l("/", (a, b) -> a / b, (a, b) -> "(" + a + " / " + b + ")");
        public static final NodeFuncLongLongToLong MOD = LONG.put_ll_l("%", (a, b) -> a % b, (a, b) -> "(" + a + " % " + b + ")");
        public static final NodeFuncLongLongToLong BITWISE_XOR = LONG.put_ll_l("^", (a, b) -> a ^ b, (a, b) -> "(" + a + " ^ " + b + ")");
        public static final NodeFuncLongLongToLong BITWISE_AND = LONG.put_ll_l("&", (a, b) -> a & b, (a, b) -> "(" + a + " & " + b + ")");
        public static final NodeFuncLongLongToLong BITWISE_OR = LONG.put_ll_l("|", (a, b) -> a | b, (a, b) -> "(" + a + " | " + b + ")");
        public static NodeFuncLongLongToBoolean LT = LONG.put_ll_b("<", (a, b) -> a < b, (a, b) -> "(" + a + " < " + b + ")");
        public static NodeFuncLongLongToBoolean GT = LONG.put_ll_b(">", (a, b) -> a > b, (a, b) -> "(" + a + " > " + b + ")");
        public static NodeFuncLongLongToBoolean LE = LONG.put_ll_b("<=", (a, b) -> a <= b, (a, b) -> "(" + a + " <= " + b + ")");
        public static NodeFuncLongLongToBoolean GE = LONG.put_ll_b(">=", (a, b) -> a >= b, (a, b) -> "(" + a + " >= " + b + ")");
        public static NodeFuncLongLongToBoolean EQ = LONG.put_ll_b("==", (a, b) -> a == b, (a, b) -> "(" + a + " == " + b + ")");
        public static NodeFuncLongLongToBoolean NE = LONG.put_ll_b("!=", (a, b) -> a != b, (a, b) -> "(" + a + " != " + b + ")");
        public static NodeFuncLongLongToLong BITSHIFT_UP = LONG.put_ll_l("<<", (a, b) -> a << (int)b, (a, b) -> "(" + a + " << " + b + ")");
        public static NodeFuncLongLongToLong BITSHIFT_DOWN = LONG.put_ll_l(">>", (a, b) -> a >> (int)b, (a, b) -> "(" + a + " >> " + b + ")");
        public static NodeFuncLongLongToLong BITSHIFT_DOWN_HARD = LONG.put_ll_l(">>>", (a, b) -> a >>> (int)b, (a, b) -> a + " >>> " + b);
        public static NodeFuncLongToDouble CVT_DOUBLE = LONG.put_l_d("(double)", a -> a, a -> "((double) " + a + ")");
        public static NodeFuncLongToObject<String> CVT_STRING = LONG.put_l_o("(string)", String.class, a -> "" + a, a -> "((string) " + a + ")");
    }
}

