/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.elem;

import buildcraft.lib.gui.BuildCraftGui;
import buildcraft.lib.gui.IContainingElement;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.misc.GuiUtil;
import java.util.ArrayList;
import java.util.List;

public class ScrollWindow
implements IContainingElement {
    public final BuildCraftGui gui;
    public final IGuiArea area;
    public final List<IGuiElement> innerElements = new ArrayList<IGuiElement>();
    public final IGuiPosition basePosition = new ScrollingElement();
    private int scrollPosition = 0;

    public ScrollWindow(BuildCraftGui gui, IGuiArea area) {
        this.gui = gui;
        this.area = area;
    }

    @Override
    public double getX() {
        return this.area.getX();
    }

    @Override
    public double getY() {
        return this.area.getY();
    }

    @Override
    public double getWidth() {
        return this.area.getWidth();
    }

    @Override
    public double getHeight() {
        return this.area.getHeight();
    }

    @Override
    public List<IGuiElement> getChildElements() {
        return this.innerElements;
    }

    @Override
    public void drawBackground(float partialTicks) {
        try (GuiUtil.AutoGlScissor s = GuiUtil.scissor(this.area);){
            for (IGuiElement element : this.innerElements) {
                element.drawBackground(partialTicks);
            }
        }
    }

    @Override
    public void drawForeground(float partialTicks) {
        try (GuiUtil.AutoGlScissor s = GuiUtil.scissor(this.area);){
            for (IGuiElement element : this.innerElements) {
                element.drawForeground(partialTicks);
            }
        }
    }

    @Override
    public void addToolTips(List<ToolTip> tooltips) {
        if (this.area.contains(this.gui.mouse)) {
            for (IGuiElement element : this.innerElements) {
                element.addToolTips(tooltips);
            }
        }
    }

    @Override
    public void onMouseClicked(int button) {
        if (this.area.contains(this.gui.mouse)) {
            IContainingElement.super.onMouseClicked(button);
        }
    }

    public IGuiPosition calculateNextPosition() {
        if (this.innerElements.isEmpty()) {
            return this.basePosition;
        }
        return this.innerElements.get(this.innerElements.size() - 1).getPosition(-1, 1);
    }

    public ScrollbarData calculateScrollbarData() {
        double totalHeight = 0.0;
        for (IGuiElement element : this.innerElements) {
            totalHeight += element.getHeight();
        }
        return new ScrollbarData(this.getHeight(), totalHeight, this.scrollPosition);
    }

    public int getScrollPosition() {
        return this.scrollPosition;
    }

    private class ScrollingElement
    implements IGuiPosition {
        private ScrollingElement() {
        }

        @Override
        public double getX() {
            return ScrollWindow.this.area.getX();
        }

        @Override
        public double getY() {
            return ScrollWindow.this.area.getY() - (double)ScrollWindow.this.scrollPosition;
        }
    }

    public class ScrollbarData {
        public final double shownHeight;
        public final double totalHeight;
        public final double position;

        public ScrollbarData(double shownHeight, double totalHeight, double position) {
            this.shownHeight = shownHeight;
            this.totalHeight = totalHeight;
            this.position = position;
        }

        public void setScrollPosition(double newPosition) {
            int rounded = (int)Math.round(newPosition);
            double maxDist = this.totalHeight - this.shownHeight;
            if (maxDist <= 0.0) {
                ScrollWindow.this.scrollPosition = 0;
                return;
            }
            if ((double)(rounded + 1) > maxDist) {
                rounded = 1 + (int)maxDist;
            } else if (rounded < 0) {
                rounded = 0;
            }
            ScrollWindow.this.scrollPosition = rounded;
        }
    }
}

