/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.list;

import buildcraft.api.lists.ListMatchHandler;
import buildcraft.lib.misc.StackUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class ListMatchHandlerFluid
extends ListMatchHandler {
    private static final List<ItemStack> clientExampleHolders = new ArrayList<ItemStack>();
    private static boolean isBuilt = false;

    private static void buildClientExampleList() {
        if (isBuilt) {
            return;
        }
        isBuilt = true;
        for (Item item : Item.field_150901_e) {
            NonNullList stacks = NonNullList.func_191196_a();
            item.func_150895_a(CreativeTabs.field_78027_g, stacks);
            for (ItemStack toTry : stacks) {
                IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)toTry);
                if (fluidHandler == null || fluidHandler.drain(1, false) != null) continue;
                clientExampleHolders.add(toTry);
            }
        }
    }

    @Override
    public boolean matches(ListMatchHandler.Type type, @Nonnull ItemStack stack, @Nonnull ItemStack target, boolean precise) {
        if (type == ListMatchHandler.Type.TYPE) {
            IFluidHandlerItem fluidHandlerStack = FluidUtil.getFluidHandler((ItemStack)stack.func_77946_l());
            IFluidHandlerItem fluidHandlerTarget = FluidUtil.getFluidHandler((ItemStack)target.func_77946_l());
            if (fluidHandlerStack != null && fluidHandlerTarget != null) {
                fluidHandlerStack.drain(Integer.MAX_VALUE, true);
                fluidHandlerTarget.drain(Integer.MAX_VALUE, true);
                ItemStack emptyStack = fluidHandlerStack.getContainer();
                ItemStack emptyTarget = fluidHandlerTarget.getContainer();
                if (StackUtil.isMatchingItem(emptyStack, emptyTarget, true, true)) {
                    return true;
                }
            }
        } else if (type == ListMatchHandler.Type.MATERIAL) {
            FluidStack fStack = FluidUtil.getFluidContained((ItemStack)stack);
            FluidStack fTarget = FluidUtil.getFluidContained((ItemStack)target);
            if (fStack != null && fTarget != null) {
                return fStack.isFluidEqual(fTarget);
            }
        }
        return false;
    }

    @Override
    public boolean isValidSource(ListMatchHandler.Type type, @Nonnull ItemStack stack) {
        if (type == ListMatchHandler.Type.TYPE) {
            return FluidUtil.getFluidHandler((ItemStack)stack) != null;
        }
        if (type == ListMatchHandler.Type.MATERIAL) {
            return FluidUtil.getFluidContained((ItemStack)stack) != null;
        }
        return false;
    }

    @Override
    public NonNullList<ItemStack> getClientExamples(ListMatchHandler.Type type, @Nonnull ItemStack stack) {
        IFluidHandlerItem fluidHandler;
        ListMatchHandlerFluid.buildClientExampleList();
        if (type == ListMatchHandler.Type.MATERIAL) {
            FluidStack fStack = FluidUtil.getFluidContained((ItemStack)stack);
            if (fStack != null) {
                NonNullList examples = NonNullList.func_191196_a();
                for (ItemStack potentialHolder : clientExampleHolders) {
                    IFluidHandlerItem fluidHandler2 = FluidUtil.getFluidHandler((ItemStack)(potentialHolder = potentialHolder.func_77946_l()));
                    if (fluidHandler2 == null || fluidHandler2.fill(fStack, true) <= 0 && fluidHandler2.drain(fStack, false) == null) continue;
                    examples.add((Object)fluidHandler2.getContainer());
                }
                return examples;
            }
        } else if (type == ListMatchHandler.Type.TYPE && (fluidHandler = FluidUtil.getFluidHandler((ItemStack)stack.func_77946_l())) != null) {
            NonNullList examples = NonNullList.func_191196_a();
            examples.add((Object)stack);
            FluidStack contained = fluidHandler.drain(Integer.MAX_VALUE, true);
            if (contained != null) {
                examples.add((Object)fluidHandler.getContainer());
                for (ItemStack potential : clientExampleHolders) {
                    IFluidHandlerItem potentialHolder = FluidUtil.getFluidHandler((ItemStack)potential);
                    if (potentialHolder.fill(contained, true) <= 0) continue;
                    examples.add((Object)potentialHolder.getContainer());
                }
            }
            return examples;
        }
        return null;
    }
}

