/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc.collect;

import buildcraft.lib.misc.collect.TypedMap;
import buildcraft.lib.misc.collect.TypedMapDirect;
import buildcraft.lib.misc.collect.TypedMapHierarchy;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class TypedKeyMap<K, V> {
    private final Supplier<TypedMap<V>> mapType;
    private final Map<K, TypedMap<V>> internalMap = new HashMap<K, TypedMap<V>>();

    public static <K, V> TypedKeyMap<K, V> createDirect() {
        return new TypedKeyMap<K, V>(TypedMapDirect::new);
    }

    public static <K, V> TypedKeyMap<K, V> createHierachy() {
        return new TypedKeyMap<K, V>(TypedMapHierarchy::new);
    }

    private TypedKeyMap(Supplier<TypedMap<V>> mapType) {
        this.mapType = mapType;
    }

    public void put(K key, V value) {
        this.internalMap.computeIfAbsent(key, k -> this.mapType.get()).put(value);
    }

    @Nullable
    public <T extends V> T get(K key, Class<T> clazz) {
        TypedMap<V> m = this.internalMap.get(key);
        if (m == null) {
            return null;
        }
        return m.get(clazz);
    }

    public Set<K> getKeys() {
        return this.internalMap.keySet();
    }

    public TypedMap<V> getAll(K key) {
        return this.internalMap.get(key);
    }
}

