/*
 * Decompiled with CFR 0.152.
 */
package uvmidnight.totaltinkers.explosives;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.events.MaterialEvent;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.Pattern;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ToolPart;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.tools.TinkerTools;
import uvmidnight.totaltinkers.IModule;
import uvmidnight.totaltinkers.TotalTinkers;
import uvmidnight.totaltinkers.explosives.ConfigExplosiveMaterials;
import uvmidnight.totaltinkers.explosives.ExplosiveArrow;
import uvmidnight.totaltinkers.explosives.ExplosiveBow;
import uvmidnight.totaltinkers.explosives.materials.ExplosiveMaterialStats;
import uvmidnight.totaltinkers.explosives.modifiers.ModRange;

public class Explosives
extends IModule {
    public static final HashMap<String, Set<IMaterialStats>> MASTER_STATS = new HashMap();
    static final String CategoryName = "Explosives Module";
    public static Property explosiveCoresFromConfig;
    public static ExplosiveBow explosiveBow;
    public static ExplosiveArrow explosiveArrow;
    public static Property explosiveBowEnabled;
    public static ToolPart explosiveCore;
    public static Modifier EXPLOSIVERANGE;
    public static Modifier TRUEEXPLOSIVE;
    public static Property trueExplosionEnabled;
    public static Property trueExplosionMult;

    public Explosives(boolean isEnabled) {
        super(isEnabled);
    }

    @Override
    public void buildConfig(Configuration cfg) {
        explosiveBowEnabled = cfg.get(CategoryName, "Explosive Bow Enabled", true, "If the explosive bow and ammunition should be enabled");
        explosiveCoresFromConfig = cfg.get(CategoryName, "Explosive Cores from Config", false, "If explosive core materials should be loaded from config directory instead of the mod's resource folder. Disables default materials. For examples check the assets.");
    }

    @Override
    public void initItems(RegistryEvent.Register<Item> event) {
        Material.UNKNOWN.addStats((IMaterialStats)new ExplosiveMaterialStats(1.0f, 1.0f, 400));
        ConfigExplosiveMaterials.load();
        Iterator<Map.Entry<String, Set<IMaterialStats>>> iterator = MASTER_STATS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Set<IMaterialStats>> entry = iterator.next();
            System.out.println(entry.getKey());
            Material material = TinkerRegistry.getMaterial((String)entry.getKey());
            if (material == Material.UNKNOWN) continue;
            for (IMaterialStats stat : entry.getValue()) {
                TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)stat);
            }
            iterator.remove();
        }
        explosiveCore = new ToolPart(720);
        explosiveCore.func_77655_b("explosiveCore").setRegistryName("explosiveCore");
        event.getRegistry().register((IForgeRegistryEntry)explosiveCore);
        TinkerRegistry.registerToolPart((IToolPart)explosiveCore);
        TotalTinkers.proxy.registerToolPartModel(explosiveCore);
        TinkerRegistry.registerStencilTableCrafting((ItemStack)Pattern.setTagForPart((ItemStack)new ItemStack((Item)TinkerTools.pattern), (Item)explosiveCore));
        for (ToolCore toolCore : TinkerRegistry.getTools()) {
            for (PartMaterialType partMaterialType : toolCore.getRequiredComponents()) {
                if (!partMaterialType.getPossibleParts().contains(explosiveCore)) continue;
                ItemStack stencil = new ItemStack((Item)TinkerTools.pattern);
                Pattern.setTagForPart((ItemStack)stencil, (Item)explosiveCore);
                TinkerRegistry.registerStencilTableCrafting((ItemStack)stencil);
                return;
            }
        }
        EXPLOSIVERANGE = new ModRange();
        EXPLOSIVERANGE.addItem(new ItemStack(Blocks.field_150335_W), 1, 1);
        if (explosiveBowEnabled.getBoolean()) {
            explosiveBow = new ExplosiveBow();
            event.getRegistry().register((IForgeRegistryEntry)explosiveBow);
            TinkerRegistry.registerToolForgeCrafting((ToolCore)explosiveBow);
            TotalTinkers.proxy.registerToolModel((ToolCore)explosiveBow);
            explosiveArrow = new ExplosiveArrow();
            event.getRegistry().register((IForgeRegistryEntry)explosiveArrow);
            TotalTinkers.proxy.registerToolModel((ToolCore)explosiveArrow);
            TinkerRegistry.registerToolForgeCrafting((ToolCore)explosiveArrow);
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register(Explosives.class);
    }

    @SubscribeEvent
    public static void addMaterialStats(MaterialEvent.MaterialRegisterEvent event) {
        Set<IMaterialStats> stats = MASTER_STATS.get(event.material.identifier);
        if (stats == null) {
            return;
        }
        for (IMaterialStats stat : stats) {
            TinkerRegistry.addMaterialStats((Material)event.material, (IMaterialStats)stat);
        }
        MASTER_STATS.remove(event.material.identifier);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        MASTER_STATS.clear();
        for (Material material : TinkerRegistry.getAllMaterials()) {
            for (ITrait trait : material.getAllTraitsForStats("handle")) {
                material.addTrait(trait, "explosivecore");
            }
        }
    }
}

