/*
 * Decompiled with CFR 0.152.
 */
package uvmidnight.totaltinkers.newweapons;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.SwordCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.library.utils.TooltipBuilder;
import slimeknights.tconstruct.tools.TinkerTools;
import uvmidnight.totaltinkers.newweapons.NewWeapons;

public class WeaponGreatblade
extends SwordCore {
    public WeaponGreatblade() {
        super(new PartMaterialType[]{PartMaterialType.handle((IToolPart)TinkerTools.toughToolRod), PartMaterialType.head((IToolPart)TinkerTools.largeSwordBlade), PartMaterialType.head((IToolPart)TinkerTools.largeSwordBlade), PartMaterialType.extra((IToolPart)NewWeapons.greatbladeCore), PartMaterialType.extra((IToolPart)TinkerTools.wideGuard)});
        this.addCategory(new Category[]{Category.WEAPON});
        this.func_77655_b("greatblade").setRegistryName("greatblade");
    }

    public static float calcPercent(ItemStack stack) {
        NBTTagCompound tag = TagUtil.getToolTag((NBTTagCompound)TagUtil.getTagSafe((ItemStack)stack));
        float tagHP = tag.func_74760_g("Attack");
        float percentCap = (float)NewWeapons.greatbladePercentCap.getDouble();
        float percentCalc = (float)NewWeapons.greatbladePercentCalc.getDouble();
        if (tagHP < percentCalc) {
            return (float)Math.min((double)percentCap, 0.7 * (double)tagHP * Math.pow(Math.E, -tagHP / percentCalc));
        }
        return (float)Math.min((double)percentCap, 0.7 * (double)percentCalc * Math.pow(Math.E, -percentCalc / percentCalc));
    }

    public float damagePotential() {
        return 0.9f;
    }

    public double attackSpeed() {
        return 0.9;
    }

    public float damageCutoff() {
        return 9000.0f;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public List<String> getInformation(ItemStack stack, boolean detailed) {
        ArrayList<String> list = new ArrayList<String>();
        TooltipBuilder info = new TooltipBuilder(stack);
        info.addDurability(!detailed);
        String out = I18n.func_135052_a((String)"tinkers.greatblade.bossmultiplier.percentMaxHp", (Object[])new Object[]{Float.valueOf(WeaponGreatblade.calcPercent(stack))});
        info.add(out);
        if (Math.abs(NewWeapons.greatbladeBossMultiplier.getDouble() - 1.0) >= 1.0E-4) {
            if (NewWeapons.greatbladeBossMultiplier.getDouble() < 1.0) {
                out = I18n.func_135052_a((String)"tinkers.greatblade.bossmultiplier.negative", (Object[])new Object[]{(1.0 - NewWeapons.greatbladeBossMultiplier.getDouble()) * 100.0});
                info.add(out);
            } else {
                out = I18n.func_135052_a((String)"tinkers.greatblade.bossmultiplier.positive", (Object[])new Object[]{NewWeapons.greatbladeBossMultiplier.getDouble() * 100.0});
                info.add(out);
            }
        }
        info.addAttack();
        if (ToolHelper.getFreeModifiers((ItemStack)stack) > 0) {
            info.addFreeModifiers();
        }
        if (detailed) {
            info.addModifierInfo();
        }
        list.addAll(info.getTooltip());
        return list;
    }

    public boolean dealDamage(ItemStack stack, EntityLivingBase player, Entity entity, float damage) {
        float percentHp = WeaponGreatblade.calcPercent(stack);
        float cooledModifier = 0.0f;
        if (player instanceof EntityPlayer) {
            float f = ((EntityPlayer)player).func_184825_o(0.5f);
            cooledModifier = 0.2f + f * f * 0.8f;
        }
        float percentDmg = 0.0f;
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase e = (EntityLivingBase)entity;
            boolean isBoss = !e.func_184222_aU();
            percentDmg = isBoss ? Math.min((float)NewWeapons.greatbladeBossCap.getDouble(), (float)NewWeapons.greatbladeBossMultiplier.getDouble() * e.func_110138_aP() * percentHp / 100.0f) : Math.min((float)NewWeapons.greatbladeNormalCap.getDouble(), e.func_110138_aP() * percentHp / 100.0f);
        } else if (entity instanceof MultiPartEntityPart) {
            MultiPartEntityPart e = (MultiPartEntityPart)entity;
            if (e.field_70259_a instanceof EntityDragon) {
                percentDmg = Math.min((float)NewWeapons.greatbladeBossCap.getDouble(), (float)NewWeapons.greatbladeBossMultiplier.getDouble() * ((EntityDragon)e.field_70259_a).func_110138_aP() * percentHp / 100.0f);
            } else if (e.field_70259_a != null && e.field_70259_a instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)e.field_70259_a;
                boolean isBoss = !e.func_184222_aU();
                percentDmg = isBoss ? Math.min((float)NewWeapons.greatbladeBossCap.getDouble(), (float)NewWeapons.greatbladeBossMultiplier.getDouble() * living.func_110138_aP() * percentHp / 100.0f) : Math.min((float)NewWeapons.greatbladeNormalCap.getDouble(), living.func_110138_aP() * percentHp / 100.0f);
            }
        }
        return super.dealDamage(stack, player, entity, damage + percentDmg * cooledModifier);
    }

    public void getTooltip(ItemStack stack, List<String> tooltips) {
        super.getTooltip(stack, tooltips);
        tooltips.add(I18n.func_135052_a((String)"tinkers.greatblade.bossmultiplier.hpHover", (Object[])new Object[]{Float.valueOf(WeaponGreatblade.calcPercent(stack))}));
    }

    public int[] getRepairParts() {
        return new int[]{1, 2};
    }

    protected ToolNBT buildTagData(List<Material> materials) {
        HandleMaterialStats handle = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
        HeadMaterialStats head0 = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        HeadMaterialStats head1 = (HeadMaterialStats)materials.get(2).getStatsOrUnknown("head");
        ExtraMaterialStats binding = (ExtraMaterialStats)materials.get(3).getStatsOrUnknown("extra");
        ToolNBT data = new ToolNBT();
        data.head(new HeadMaterialStats[]{head0, head1});
        data.extra(new ExtraMaterialStats[]{binding});
        data.handle(new HandleMaterialStats[]{handle});
        data.attack += 1.0f;
        data.durability = (int)((double)data.durability * 1.4);
        return data;
    }
}

