/*
 * Decompiled with CFR 0.152.
 */
package uvmidnight.totaltinkers.newweapons;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.SwordCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.library.utils.TooltipBuilder;
import slimeknights.tconstruct.tools.TinkerTools;
import uvmidnight.totaltinkers.newweapons.NewWeapons;
import uvmidnight.totaltinkers.newweapons.potion.PotionHemorrhageEffect;

public class WeaponScimitar
extends SwordCore {
    public WeaponScimitar() {
        super(new PartMaterialType[]{PartMaterialType.handle((IToolPart)TinkerTools.toughToolRod), PartMaterialType.head((IToolPart)TinkerTools.swordBlade), PartMaterialType.extra((IToolPart)TinkerTools.binding)});
        this.addCategory(new Category[]{Category.WEAPON});
        this.func_77655_b("scimitar").setRegistryName("scimitar");
    }

    protected ToolNBT buildTagData(List<Material> materials) {
        HandleMaterialStats handle = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
        HeadMaterialStats head0 = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        ExtraMaterialStats binding = (ExtraMaterialStats)materials.get(2).getStatsOrUnknown("extra");
        ToolNBT data = new ToolNBT();
        data.head(new HeadMaterialStats[]{head0});
        data.extra(new ExtraMaterialStats[]{binding});
        data.handle(new HandleMaterialStats[]{handle});
        data.durability = (int)((double)data.durability * 1.4);
        data.attack += 1.0f;
        return data;
    }

    public float damagePotential() {
        return 0.45f;
    }

    public double attackSpeed() {
        return 1.7;
    }

    public boolean dealDamage(ItemStack stack, EntityLivingBase player, Entity entity, float damage) {
        boolean attack = super.dealDamage(stack, player, entity, damage);
        if (this.readyForSpecialAttack(player) && attack && entity instanceof EntityLivingBase && (entity.func_184222_aU() || NewWeapons.canScimitarBleedDamageBosses.getBoolean())) {
            Vec3d vec3d;
            boolean isBlocking = false;
            DamageSource damageSource = player instanceof EntityPlayer ? DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)player)) : DamageSource.func_76358_a((EntityLivingBase)player);
            if (!damageSource.func_76363_c() && ((EntityLivingBase)entity).func_184585_cz() && (vec3d = damageSource.func_188404_v()) != null) {
                Vec3d vec3d1 = entity.func_70676_i(1.0f);
                Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)).func_72432_b();
                vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
                if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                    isBlocking = true;
                }
            }
            if (!isBlocking) {
                int amp = 0;
                int oldDuration = 0;
                if (((EntityLivingBase)entity).func_70644_a((Potion)NewWeapons.potionHemorrhage)) {
                    amp = ((EntityLivingBase)entity).func_70660_b((Potion)NewWeapons.potionHemorrhage).func_76458_c();
                    oldDuration = ((EntityLivingBase)entity).func_70660_b((Potion)NewWeapons.potionHemorrhage).func_76459_b();
                }
                NBTTagCompound tag = TagUtil.getToolTag((NBTTagCompound)TagUtil.getTagSafe((ItemStack)stack));
                int duration = Math.max((int)(tag.func_74760_g("Attack") * 8.0f), 0);
                if (NewWeapons.scimitarBleedDurationRefreshable.getBoolean() || !((EntityLivingBase)entity).func_70644_a((Potion)NewWeapons.potionHemorrhage)) {
                    if (NewWeapons.scimitarDamageStackable.getBoolean()) {
                        ((EntityLivingBase)entity).func_70690_d((PotionEffect)new PotionHemorrhageEffect(NewWeapons.potionHemorrhage, duration, amp + 1));
                    } else {
                        ((EntityLivingBase)entity).func_70690_d((PotionEffect)new PotionHemorrhageEffect(NewWeapons.potionHemorrhage, duration, amp));
                    }
                } else if (NewWeapons.scimitarDamageStackable.getBoolean()) {
                    ((EntityLivingBase)entity).func_70690_d((PotionEffect)new PotionHemorrhageEffect(NewWeapons.potionHemorrhage, oldDuration, amp + 1));
                }
            }
        }
        return attack;
    }

    public List<String> getInformation(ItemStack stack, boolean detailed) {
        ArrayList<String> list = new ArrayList<String>();
        TooltipBuilder info = new TooltipBuilder(stack);
        NBTTagCompound tag = TagUtil.getToolTag((NBTTagCompound)TagUtil.getTagSafe((ItemStack)stack));
        float bleedduration = Math.max(tag.func_74760_g("Attack") * 8.0f / 20.0f, 0.0f);
        info.addDurability(!detailed);
        String out = I18n.func_135052_a((String)"tinkers.scimitar.bleed.duration", (Object[])new Object[]{Float.valueOf(bleedduration)});
        info.add(out);
        info.addAttack();
        if (ToolHelper.getFreeModifiers((ItemStack)stack) > 0) {
            info.addFreeModifiers();
        }
        if (detailed) {
            info.addModifierInfo();
        }
        list.addAll(info.getTooltip());
        return list;
    }

    public void getTooltip(ItemStack stack, List<String> tooltips) {
        super.getTooltip(stack, tooltips);
        NBTTagCompound tag = TagUtil.getToolTag((NBTTagCompound)TagUtil.getTagSafe((ItemStack)stack));
        float bleedduration = Math.max(tag.func_74760_g("Attack") * 8.0f / 20.0f, 0.0f);
        tooltips.add(I18n.func_135052_a((String)"tinkers.scimitar.bleed.hover", (Object[])new Object[]{Float.valueOf(bleedduration)}));
    }
}

