/*
 * Decompiled with CFR 0.152.
 */
package uvmidnight.totaltinkers.oldweapons;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.client.crosshair.Crosshairs;
import slimeknights.tconstruct.library.client.crosshair.ICrosshair;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tools.ProjectileLauncherNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.ranged.item.CrossBow;
import uvmidnight.totaltinkers.oldweapons.OldWeapons;

public class WeaponCrossbowOveride
extends CrossBow {
    private static final String TAG_ReloadProgress = "ReloadProgress";
    private static final String TAG_Reloading = "getReloadingProgress";
    private static boolean autoCrossbowReload;
    private static boolean crossbowOldCrosshair;
    private static boolean offhandTicking;

    public WeaponCrossbowOveride() {
        autoCrossbowReload = OldWeapons.autoCrossbowReload.getBoolean();
        crossbowOldCrosshair = OldWeapons.crossbowOldCrosshair.getBoolean();
        offhandTicking = OldWeapons.autoCrossbowDualWield.getBoolean();
        if (autoCrossbowReload) {
            this.func_185043_a(PROPERTY_PULL_PROGRESS, new IItemPropertyGetter(){

                @SideOnly(value=Side.CLIENT)
                public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                    if (entityIn != null) {
                        if (WeaponCrossbowOveride.this.isLoaded(stack)) {
                            return 1.0f;
                        }
                        return WeaponCrossbowOveride.this.isReloading(stack) ? WeaponCrossbowOveride.this.getDrawbackProgress(stack, WeaponCrossbowOveride.this.getReloadingProgress(stack)) : 0.0f;
                    }
                    return 0.0f;
                }
            });
            this.func_185043_a(PROPERTY_IS_PULLING, new IItemPropertyGetter(){

                @SideOnly(value=Side.CLIENT)
                public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                    return this.applyIf(stack, worldIn, entityIn) ? 1.0f : 0.0f;
                }

                @SideOnly(value=Side.CLIENT)
                public boolean applyIf(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                    return WeaponCrossbowOveride.this.isReloading(stack);
                }
            });
            this.func_185043_a(PROPERTY_IS_LOADED, new IItemPropertyGetter(){

                @SideOnly(value=Side.CLIENT)
                public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                    return this.applyIf(stack, worldIn, entityIn) ? 1.0f : 0.0f;
                }

                @SideOnly(value=Side.CLIENT)
                public boolean applyIf(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                    return entityIn != null && WeaponCrossbowOveride.this.isLoaded(stack) && !WeaponCrossbowOveride.this.isReloading(stack);
                }
            });
        }
        this.addCategory(new Category[]{Category.LAUNCHER});
        this.func_77655_b("tconstruct:crossbow").setRegistryName("tconstruct:crossbow");
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (autoCrossbowReload) {
            playerIn.func_184598_c(hand);
            ItemStack itemStackIn = playerIn.func_184586_b(hand);
            NBTTagCompound tags = TagUtil.getTagSafe((ItemStack)itemStackIn);
            if (this.isLoaded(itemStackIn)) {
                if (!this.findAmmo(itemStackIn, (EntityLivingBase)playerIn).func_190926_b() || playerIn.field_71075_bZ.field_75098_d) {
                    super.func_77659_a(worldIn, playerIn, hand);
                    this.initiateReload(itemStackIn, playerIn, tags);
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
                }
            } else if (!(this.isReloading(itemStackIn) || this.findAmmo(itemStackIn, (EntityLivingBase)playerIn).func_190926_b() && !playerIn.field_71075_bZ.field_75098_d)) {
                this.initiateReload(itemStackIn, playerIn, tags);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
        }
        return super.func_77659_a(worldIn, playerIn, hand);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (autoCrossbowReload) {
            this.onUpdateTraits(stack, world, entity, itemSlot, isSelected);
            if (!stack.func_77942_o()) {
                return;
            }
            if (!(entity instanceof EntityPlayer)) {
                return;
            }
            NBTTagCompound tags = TagUtil.getTagSafe((ItemStack)stack);
            EntityPlayer player = (EntityPlayer)entity;
            if (offhandTicking) {
                if (player.field_71071_by.func_70448_g() != stack && player.func_184592_cb() != stack) {
                    if (!this.isLoaded(stack)) {
                        tags.func_74768_a(TAG_ReloadProgress, 0);
                    }
                    return;
                }
            } else if (player.field_71071_by.func_70448_g() != stack) {
                if (!this.isLoaded(stack)) {
                    tags.func_74768_a(TAG_ReloadProgress, 0);
                }
                return;
            }
            if (this.isReloading(stack)) {
                int timeLeft = this.getReloadingProgress(stack);
                if (timeLeft == -1) {
                    ++timeLeft;
                }
                tags.func_74768_a(TAG_ReloadProgress, ++timeLeft);
                if ((double)(this.getDrawbackProgress(stack, timeLeft) - 1.0f) >= -1.0E-7) {
                    this.setLoaded(stack, true);
                    tags.func_74757_a(TAG_Reloading, false);
                    Sounds.PlaySoundForPlayer((Entity)player, (SoundEvent)Sounds.crossbow_reload, (float)1.5f, (float)(0.9f + field_77697_d.nextFloat() * 0.1f));
                }
            }
            if (!this.isReloading(stack) && tags.func_74762_e(TAG_ReloadProgress) == -1) {
                tags.func_74757_a(TAG_Reloading, true);
            }
        } else {
            super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        }
    }

    protected float getDrawbackProgress(ItemStack itemStack, int timePassed) {
        if (autoCrossbowReload) {
            float drawProgress = ProjectileLauncherNBT.from((ItemStack)itemStack).drawSpeed * (float)timePassed;
            return Math.min(1.0f, drawProgress / (float)this.getDrawTime());
        }
        return super.getDrawbackProgress(itemStack, timePassed);
    }

    public float getDrawbackProgress(ItemStack itemstack, EntityLivingBase entityIn) {
        if (autoCrossbowReload) {
            int timePassed = this.getReloadingProgress(itemstack);
            return this.getDrawbackProgress(itemstack, timePassed);
        }
        return super.getDrawbackProgress(itemstack, entityIn);
    }

    public int getReloadingProgress(ItemStack stack) {
        return TagUtil.getTagSafe((ItemStack)stack).func_74762_e(TAG_ReloadProgress);
    }

    public boolean isReloading(ItemStack stack) {
        return TagUtil.getTagSafe((ItemStack)stack).func_74767_n(TAG_Reloading);
    }

    public void initiateReload(ItemStack itemStackIn, EntityPlayer player, NBTTagCompound tags) {
        if (ToolHelper.isBroken((ItemStack)itemStackIn)) {
            return;
        }
        if (!(this.findAmmo(itemStackIn, (EntityLivingBase)player).func_190926_b() && !player.field_71075_bZ.field_75098_d || this.isLoaded(itemStackIn))) {
            tags.func_74757_a(TAG_Reloading, true);
            tags.func_74768_a(TAG_ReloadProgress, 0);
        }
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public ICrosshair getCrosshair(ItemStack itemStack, EntityPlayer player) {
        if (crossbowOldCrosshair) {
            return Crosshairs.SQUARE;
        }
        return Crosshairs.T;
    }

    @SideOnly(value=Side.CLIENT)
    public float getCrosshairState(ItemStack itemStack, EntityPlayer player) {
        if (autoCrossbowReload) {
            if (this.isLoaded(itemStack)) {
                return 1.0f;
            }
            if (offhandTicking && player.func_184592_cb().func_77973_b() instanceof WeaponCrossbowOveride && player.func_184614_ca().func_77973_b() instanceof WeaponCrossbowOveride) {
                return 1.0f;
            }
            if (this.isReloading(itemStack)) {
                return this.getDrawbackProgress(itemStack, this.getReloadingProgress(itemStack));
            }
            return 0.0f;
        }
        return super.getCrosshairState(itemStack, player);
    }
}

