/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.armor;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IItemHudInfo;
import ic2.core.item.armor.jetpack.IBoostingJetpack;
import java.util.LinkedList;
import java.util.List;
import net.lrsoft.mets.MoreElectricTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.EnumHelper;

public class AdvancedJetPack
extends ItemArmor
implements IElectricItem,
IItemHudInfo,
IBoostingJetpack {
    private static ItemArmor.ArmorMaterial jetPackMaterial = EnumHelper.addArmorMaterial((String)"advanced_jetpack", (String)"mets:advanced_jetpack", (int)33, (int[])new int[]{3, 12, 8, 4}, (int)20, (SoundEvent)SoundEvents.field_187725_r, (float)2.0f);
    private static double maxStorageEnergy = 1000000.0;
    private static double transferSpeed = 512.0;

    public AdvancedJetPack() {
        super(jetPackMaterial, 0, EntityEquipmentSlot.CHEST);
        this.func_77655_b("mets.advanced_jetpack");
        this.setRegistryName("mets", "advanced_jetpack");
        this.func_77637_a(MoreElectricTools.CREATIVE_TAB);
        this.func_77656_e(233);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public boolean drainEnergy(ItemStack pack, int amount) {
        return ElectricItem.manager.discharge(pack, (double)(amount + 3), Integer.MAX_VALUE, true, false, false) > 0.0;
    }

    public double getChargeLevel(ItemStack stack) {
        return ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public float getDropPercentage(ItemStack arg0) {
        return 0.0f;
    }

    public float getHoverMultiplier(ItemStack arg0, boolean arg1) {
        return 1.0f;
    }

    public float getPower(ItemStack arg0) {
        return 1.0f;
    }

    public float getWorldHeightDivisor(ItemStack arg0) {
        return 0.1f;
    }

    public boolean isJetpackActive(ItemStack arg0) {
        return true;
    }

    public List<String> getHudInfo(ItemStack stack, boolean advanced) {
        LinkedList<String> info = new LinkedList<String>();
        info.add(ElectricItem.manager.getToolTip(stack));
        return info;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxCharge(ItemStack stack) {
        return maxStorageEnergy;
    }

    public int getTier(ItemStack stack) {
        return 3;
    }

    public double getTransferLimit(ItemStack stack) {
        return transferSpeed;
    }

    public float getBaseThrust(ItemStack arg0, boolean arg1) {
        return 0.3f;
    }

    public float getBoostThrust(EntityPlayer arg0, ItemStack arg1, boolean arg2) {
        return 0.2f;
    }

    public float getHoverBoost(EntityPlayer arg0, ItemStack arg1, boolean arg2) {
        return 0.2f;
    }

    public boolean useBoostPower(ItemStack pack, float amount) {
        return ElectricItem.manager.discharge(pack, (double)(amount + 3.0f), Integer.MAX_VALUE, true, false, false) > 0.0;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }
}

