/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.armor;

import com.google.common.collect.Multimap;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IHazmatLike;
import ic2.api.item.IItemHudInfo;
import ic2.core.IC2;
import ic2.core.init.Localization;
import ic2.core.item.IPseudoDamageItem;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.lrsoft.mets.MoreElectricTools;
import net.lrsoft.mets.manager.ConfigManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.util.EnumHelper;

public class HeavyQuantumSuit
extends ItemArmor
implements ISpecialArmor,
IPseudoDamageItem,
IElectricItem,
IItemHudInfo,
IHazmatLike {
    private static ItemArmor.ArmorMaterial defaultMaterial = EnumHelper.addArmorMaterial((String)"heavy_quantum_suit", (String)"mets:heavy_quantum_suit", (int)50, (int[])new int[]{7, 15, 9, 6}, (int)40, (SoundEvent)SoundEvents.field_187725_r, (float)2.0f);
    public static final UUID KNOWBACK_MODIFER = UUID.fromString("191a4c46-856a-4a51-a3d9-a466f1a1ca5b");
    private static double maxStorageEnergy = 1.0E7;
    private static double transferSpeed = 4096.0;
    private static int suitTier = 4;

    public HeavyQuantumSuit(String itemName) {
        super(defaultMaterial, 0, EntityEquipmentSlot.CHEST);
        this.func_77655_b("mets." + itemName);
        this.setRegistryName("mets", itemName);
        this.func_77637_a(MoreElectricTools.CREATIVE_TAB);
        this.func_77656_e(2333);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        IC2.platform.profilerStartSection("QuantumBodyarmor");
        player.func_70066_B();
        float currentHealth = player.func_110143_aJ();
        if (currentHealth < player.func_110138_aP() * 0.2f && ElectricItem.manager.use(itemStack, 5000.0, (EntityLivingBase)player)) {
            player.func_70606_j(currentHealth + 1.0f);
        }
        IC2.platform.profilerEndSection();
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        int energyPerDamage = (int)ConfigManager.HeavyQuantumSuitDamageEnergyCost;
        int damageLimit = Integer.MAX_VALUE;
        if (energyPerDamage > 0) {
            damageLimit = (int)Math.min((double)damageLimit, 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage);
        }
        return new ISpecialArmor.ArmorProperties(8, 0.5, damageLimit);
    }

    public boolean addsProtection(EntityLivingBase entity, EntityEquipmentSlot slot, ItemStack stack) {
        return ElectricItem.manager.getCharge(stack) > 0.0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        ElectricItem.manager.discharge(stack, (double)damage * ConfigManager.HeavyQuantumSuitDamageEnergyCost, Integer.MAX_VALUE, true, false, false);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.CHEST) {
            multimap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(KNOWBACK_MODIFER, "Weapon modifier", 1.0, 0));
        }
        return multimap;
    }

    public void setStackDamage(ItemStack stack, int damage) {
        this.setDamage(stack, damage);
    }

    public List<String> getHudInfo(ItemStack stack, boolean advanced) {
        LinkedList<String> info = new LinkedList<String>();
        info.add(ElectricItem.manager.getToolTip(stack));
        Object[] objectArray = new Object[1];
        objectArray[0] = suitTier;
        info.add(Localization.translate((String)"ic2.item.tooltip.PowerTier", (Object[])objectArray));
        return info;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public double getMaxCharge(ItemStack stack) {
        return maxStorageEnergy;
    }

    public int getTier(ItemStack stack) {
        return suitTier;
    }

    public double getTransferLimit(ItemStack stack) {
        return transferSpeed;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }
}

