/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.blade;

import mods.flammpfeil.slashblade.ItemSlashBladeNamed;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.specialeffect.IRemovable;
import mods.flammpfeil.slashblade.specialeffect.ISpecialEffect;
import mods.flammpfeil.slashblade.specialeffect.SpecialEffects;
import mods.flammpfeil.slashblade.util.SlashBladeEvent;
import mods.flammpfeil.slashblade.util.SlashBladeHooks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BloodRevSE
implements ISpecialEffect,
IRemovable {
    private static final String EffectKey = "BloodRevSE";
    private int interval = 0;

    private boolean useBlade(ItemSlashBlade.ComboSequence sequence) {
        if (sequence.useScabbard) {
            return false;
        }
        if (sequence == ItemSlashBlade.ComboSequence.None) {
            return false;
        }
        return sequence != ItemSlashBlade.ComboSequence.Noutou;
    }

    @SubscribeEvent
    public void onImpactEffectEvent(SlashBladeEvent.ImpactEffectEvent event) {
        if (!this.useBlade(event.sequence)) {
            return;
        }
        if (!SpecialEffects.isPlayer((Entity)event.user)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.user;
        switch (SpecialEffects.isEffective((EntityPlayer)player, (ItemStack)event.blade, (ISpecialEffect)this)) {
            case None: {
                if (this.interval > 0) {
                    --this.interval;
                }
                return;
            }
            case Effective: {
                if (this.interval <= 0) {
                    ItemSlashBlade.damageItem((ItemStack)event.blade, (int)5, (EntityLivingBase)player);
                    float damage = 5.0f + (float)(ItemSlashBladeNamed.RepairCount.get(event.blade.func_77978_p()) / 10);
                    player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 150, 3));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 100, 3));
                    if (damage > 12.0f) {
                        damage = 12.0f;
                    }
                    if (event.target.func_70681_au().nextInt(2) != 0) {
                        return;
                    }
                    if (event.target != null) {
                        event.target.func_184185_a(SoundEvents.field_187541_bC, 0.7f, 1.6f + (event.target.func_70681_au().nextFloat() - event.target.func_70681_au().nextFloat()) * 0.4f);
                        event.target.field_70170_p.func_72876_a((Entity)event.user, event.target.field_70165_t, event.target.field_70163_u, event.target.field_70161_v, damage, false);
                    }
                    this.interval += 7;
                    break;
                }
                --this.interval;
                break;
            }
            case NonEffective: {
                if (this.interval > 0) {
                    --this.interval;
                }
                if (player.func_70681_au().nextInt(4) == 0) break;
                player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 100, 2));
                player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 100, 2));
                return;
            }
        }
        player.func_71047_c((Entity)event.target);
    }

    @SubscribeEvent
    public void onUpdateItemSlashBlade(SlashBladeEvent.OnUpdateEvent event) {
        if (!SpecialEffects.isPlayer((Entity)event.entity)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entity;
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound((ItemStack)event.blade);
        if (!this.useBlade(ItemSlashBlade.getComboSequence((NBTTagCompound)tag))) {
            return;
        }
        switch (SpecialEffects.isEffective((EntityPlayer)player, (ItemStack)event.blade, (ISpecialEffect)this)) {
            case None: {
                return;
            }
            case NonEffective: {
                if (player.func_70681_au().nextInt(4) == 0) break;
                return;
            }
            case Effective: {
                return;
            }
        }
    }

    public void register() {
        SlashBladeHooks.EventBus.register((Object)this);
    }

    public int getDefaultRequiredLevel() {
        return 35;
    }

    public String getEffectKey() {
        return EffectKey;
    }

    public boolean canCopy(ItemStack arg0) {
        return false;
    }

    public boolean canRemoval(ItemStack arg0) {
        return false;
    }
}

