/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.blade;

import mods.flammpfeil.slashblade.entity.EntityWitherSword;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.specialeffect.IRemovable;
import mods.flammpfeil.slashblade.specialeffect.ISpecialEffect;
import mods.flammpfeil.slashblade.specialeffect.SpecialEffects;
import mods.flammpfeil.slashblade.util.SlashBladeEvent;
import mods.flammpfeil.slashblade.util.SlashBladeHooks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class KineticSE
implements ISpecialEffect,
IRemovable {
    private static final String EffectKey = "KineticSE";
    private boolean burst = false;
    private int interval = 0;

    private boolean useBlade(ItemSlashBlade.ComboSequence sequence) {
        if (sequence.useScabbard) {
            return false;
        }
        if (sequence == ItemSlashBlade.ComboSequence.None) {
            return false;
        }
        return sequence != ItemSlashBlade.ComboSequence.Noutou;
    }

    @SubscribeEvent
    public void onImpactEffectEvent(SlashBladeEvent.ImpactEffectEvent event) {
        if (!this.useBlade(event.sequence)) {
            return;
        }
        if (!SpecialEffects.isPlayer((Entity)event.user)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.user;
        switch (SpecialEffects.isEffective((EntityPlayer)player, (ItemStack)event.blade, (ISpecialEffect)this)) {
            case None: {
                if (this.interval > 0) {
                    --this.interval;
                }
                return;
            }
            case Effective: {
                float damage;
                try {
                    damage = event.target.func_110143_aJ() / 4.0f;
                }
                catch (Exception e) {
                    damage = 20.0f + (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)event.blade);
                }
                if (this.interval <= 0) {
                    EntityWitherSword entityDrive;
                    if (event.target != null && (entityDrive = new EntityWitherSword(event.target.field_70170_p, (EntityLivingBase)player, damage, 90.0f)) != null) {
                        entityDrive.setInterval(1);
                        entityDrive.setLifeTime(40);
                        int color = this.burst ? -16777137 : -16777083;
                        entityDrive.setColor(color);
                        entityDrive.setBurst(this.burst);
                        entityDrive.setTargetEntityId(event.target.func_145782_y());
                        event.target.field_70170_p.func_72838_d((Entity)entityDrive);
                        this.burst = !this.burst;
                    }
                    this.interval += 5;
                    break;
                }
                --this.interval;
                break;
            }
            case NonEffective: {
                if (this.interval <= 0) break;
                --this.interval;
            }
        }
        player.func_71047_c((Entity)event.target);
    }

    @SubscribeEvent
    public void onUpdateItemSlashBlade(SlashBladeEvent.OnUpdateEvent event) {
        if (!SpecialEffects.isPlayer((Entity)event.entity)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entity;
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound((ItemStack)event.blade);
        if (!this.useBlade(ItemSlashBlade.getComboSequence((NBTTagCompound)tag))) {
            return;
        }
        switch (SpecialEffects.isEffective((EntityPlayer)player, (ItemStack)event.blade, (ISpecialEffect)this)) {
            case None: {
                return;
            }
            case NonEffective: {
                if (player.func_70681_au().nextInt(4) == 0) break;
                return;
            }
            case Effective: {
                return;
            }
        }
    }

    public void register() {
        SlashBladeHooks.EventBus.register((Object)this);
    }

    public int getDefaultRequiredLevel() {
        return 25;
    }

    public String getEffectKey() {
        return EffectKey;
    }

    public boolean canCopy(ItemStack arg0) {
        return false;
    }

    public boolean canRemoval(ItemStack arg0) {
        return false;
    }
}

