/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.block.tileentity.GESU;

import ic2.core.block.TileEntityBlock;
import net.lrsoft.mets.block.tileentity.GESU.IGESUPart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class TileEntityGESUCore
extends TileEntityBlock {
    private double gesuFuel = 0.0;
    private int currentTick = 0;
    private boolean isStructureComplete = false;

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.gesuFuel = compound.func_74769_h("gesuFuel");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound nbtTagCompound = super.func_189515_b(compound);
        nbtTagCompound.func_74780_a("gesuFuel", this.gesuFuel);
        return nbtTagCompound;
    }

    protected void updateEntityServer() {
        super.updateEntityServer();
        if (this.currentTick % 15 == 0) {
            this.checkStructureComplete();
        }
        ++this.currentTick;
    }

    private void checkStructureComplete() {
        TileEntity upPart = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 1, 0));
        TileEntity downPart = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, -1, 0));
        TileEntity northPart = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(1, 0, 0));
        TileEntity southPart = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-1, 0, 0));
        TileEntity westPart = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, 1));
        TileEntity eastPart = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, -1));
        if (this.checkPortAndUpdate(upPart) && this.checkPortAndUpdate(downPart) && this.checkPortAndUpdate(northPart) && this.checkPortAndUpdate(southPart) && this.checkPortAndUpdate(westPart) && this.checkPortAndUpdate(eastPart)) {
            ((IGESUPart)upPart).setCoreComplete(true);
            ((IGESUPart)downPart).setCoreComplete(true);
            ((IGESUPart)northPart).setCoreComplete(true);
            ((IGESUPart)southPart).setCoreComplete(true);
            ((IGESUPart)westPart).setCoreComplete(true);
            ((IGESUPart)eastPart).setCoreComplete(true);
            this.isStructureComplete = true;
        } else {
            this.isStructureComplete = false;
        }
    }

    public synchronized boolean addFuel(double fuel) {
        if (this.isStructureComplete) {
            if (this.gesuFuel + fuel <= Double.MAX_VALUE) {
                this.gesuFuel += fuel;
                return true;
            }
            this.gesuFuel = Double.MAX_VALUE;
        }
        return false;
    }

    public synchronized boolean consumeFuel(double fuel) {
        if (this.isStructureComplete && this.gesuFuel - fuel >= 0.0) {
            this.gesuFuel -= fuel;
            return true;
        }
        return false;
    }

    public synchronized double getGESUFuel() {
        return this.gesuFuel;
    }

    private boolean checkPortAndUpdate(TileEntity te) {
        if (te != null && te instanceof IGESUPart) {
            IGESUPart port = (IGESUPart)te;
            port.setCore(new Vec3d((Vec3i)this.field_174879_c));
            port.setCoreComplete(false);
            return true;
        }
        return false;
    }
}

