/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.block.tileentity.GESU;

import ic2.api.network.NetworkHelper;
import java.text.DecimalFormat;
import net.lrsoft.mets.block.tileentity.GESU.IGESUPart;
import net.lrsoft.mets.block.tileentity.GESU.TileEntityGESUCore;
import net.lrsoft.mets.block.tileentity.OilRig.TileEntityGUIMachine;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class TileEntityGESUInputPort
extends TileEntityGUIMachine
implements IGESUPart {
    private Vec3d corePosition = null;
    private boolean isStructureCompleted = false;
    private static int transferSpeed = 81920;
    private int tick = 0;
    private double remainingEU = 0.0;
    private static DecimalFormat energyFormat = new DecimalFormat("#.#");

    public TileEntityGESUInputPort() {
        super(transferSpeed, Integer.MAX_VALUE);
    }

    protected void updateEntityServer() {
        super.updateEntityServer();
        this.updateTileEntity();
    }

    private void updateTileEntity() {
        if (this.isStructureCompleted) {
            TileEntityGESUCore core;
            TileEntity te;
            if (this.energy.canUseEnergy((double)transferSpeed)) {
                te = this.field_145850_b.func_175625_s(new BlockPos(this.corePosition));
                if (te != null && te instanceof TileEntityGESUCore) {
                    core = (TileEntityGESUCore)te;
                    if (core.addFuel(1.0)) {
                        this.energy.useEnergy((double)transferSpeed);
                        this.setActive(true);
                    }
                } else {
                    this.resume();
                    this.setActive(false);
                }
            }
            if (this.tick % 15 == 0) {
                te = this.field_145850_b.func_175625_s(new BlockPos(this.corePosition));
                if (te != null && te instanceof TileEntityGESUCore) {
                    core = (TileEntityGESUCore)te;
                    this.remainingEU = core.getGESUFuel() * 81920.0;
                    NetworkHelper.updateTileEntityField((TileEntity)this, (String)"remainingEU");
                } else {
                    this.resume();
                }
            }
            ++this.tick;
        } else {
            this.setActive(false);
        }
    }

    private void resume() {
        this.isStructureCompleted = false;
        this.corePosition = null;
    }

    public String getTotalEnergy() {
        return energyFormat.format(this.remainingEU);
    }

    public double getEnergy() {
        return this.energy.getEnergy();
    }

    public boolean useEnergy(double amount) {
        return this.energy.useEnergy(amount);
    }

    @Override
    public synchronized void setCore(Vec3d coord) {
        this.corePosition = coord;
    }

    @Override
    public synchronized void setCoreComplete(boolean isComplete) {
        this.isStructureCompleted = isComplete;
    }
}

