/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.block.tileentity.GESU;

import ic2.api.network.NetworkHelper;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import java.text.DecimalFormat;
import net.lrsoft.mets.block.tileentity.GESU.IGESUPart;
import net.lrsoft.mets.block.tileentity.GESU.TileEntityGESUCore;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class TileEntityGESUOutputPort
extends TileEntityBaseGenerator
implements IGESUPart {
    private Vec3d corePosition = null;
    private boolean isStructureCompleted = false;
    private static int transferSpeed = 81920;
    private double remainingEU = 0.0;
    private int tick = 0;
    private static DecimalFormat energyFormat = new DecimalFormat("#.#");

    public TileEntityGESUOutputPort() {
        super((double)transferSpeed, 5, transferSpeed);
    }

    protected TileEntityGESUOutputPort(int tier) {
        super((double)transferSpeed, tier, transferSpeed);
    }

    protected void updateEntityServer() {
        super.updateEntityServer();
        this.updateTileEntity();
    }

    private void updateTileEntity() {
        if (this.isStructureCompleted) {
            if (this.tick % 15 == 0) {
                TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(this.corePosition));
                if (te != null && te instanceof TileEntityGESUCore) {
                    TileEntityGESUCore core = (TileEntityGESUCore)te;
                    this.remainingEU = core.getGESUFuel() * 81920.0;
                    NetworkHelper.updateTileEntityField((TileEntity)this, (String)"remainingEU");
                } else {
                    this.resume();
                }
            }
            ++this.tick;
            this.setActive(true);
        } else {
            this.remainingEU = 0.0;
            NetworkHelper.updateTileEntityField((TileEntity)this, (String)"remainingEU");
            this.setActive(false);
        }
    }

    private void resume() {
        this.isStructureCompleted = false;
        this.corePosition = null;
    }

    @Override
    public synchronized void setCore(Vec3d coord) {
        this.corePosition = coord;
    }

    @Override
    public synchronized void setCoreComplete(boolean isComplete) {
        this.isStructureCompleted = isComplete;
    }

    public String getTotalEnergy() {
        return energyFormat.format(this.remainingEU);
    }

    public boolean gainFuel() {
        TileEntity te;
        if (this.isStructureCompleted && this.energy.getEnergy() <= 0.0 && (te = this.field_145850_b.func_175625_s(new BlockPos(this.corePosition))) instanceof TileEntityGESUCore) {
            TileEntityGESUCore core = (TileEntityGESUCore)te;
            this.remainingEU = core.getGESUFuel() * 81920.0;
            if (core.consumeFuel(1.0)) {
                this.energy.addEnergy((double)transferSpeed);
                return true;
            }
        }
        return false;
    }
}

