/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.block.tileentity.LargeFabricator;

import ic2.core.block.TileEntityBlock;
import java.util.Vector;
import net.lrsoft.mets.block.tileentity.LargeFabricator.IFabricatorPart;
import net.lrsoft.mets.block.tileentity.LargeFabricator.TileEntityFabricatorInput;
import net.lrsoft.mets.block.tileentity.LargeFabricator.TileEntityFabricatorScrap;
import net.lrsoft.mets.block.tileentity.LargeFabricator.TileEntityFabricatorTank;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class TileEntityFabricatorCore
extends TileEntityBlock {
    private int currentTick = 0;
    private boolean isStructureComplete = false;
    private boolean shouldProcess = true;
    private int scrapFuel = 0;
    private Vector<IFabricatorPart> inputPart = new Vector();
    private IFabricatorPart outputPart;
    private IFabricatorPart scrapPart;

    protected void updateEntityServer() {
        super.updateEntityServer();
        if (this.currentTick % 15 == 0) {
            this.checkStructureComplete();
        }
        if (this.isStructureComplete) {
            this.updateTileEntity();
        }
        ++this.currentTick;
    }

    private void updateTileEntity() {
        TileEntityFabricatorScrap scrapSlot = null;
        if (this.scrapPart != null) {
            scrapSlot = (TileEntityFabricatorScrap)this.scrapPart;
        }
        for (IFabricatorPart supply : this.inputPart) {
            TileEntityFabricatorInput inputTemp = (TileEntityFabricatorInput)supply;
            if (!inputTemp.canConsume(inputTemp.getMaxEnergy())) continue;
            TileEntityFabricatorTank outputTemp = (TileEntityFabricatorTank)this.outputPart;
            if (outputTemp == null || !outputTemp.addToOutputSlot(1)) break;
            float discount = scrapSlot == null ? 0.0f : scrapSlot.consumeScrapValue((float)inputTemp.getMaxEnergy());
            inputTemp.consumeEnergy(inputTemp.getMaxEnergy() - (double)discount);
            break;
        }
    }

    private void checkStructureComplete() {
        TileEntity upPart = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 1, 0));
        TileEntity downPart = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, -1, 0));
        TileEntity northPart = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(1, 0, 0));
        TileEntity southPart = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-1, 0, 0));
        TileEntity westPart = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, 1));
        TileEntity eastPart = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, -1));
        if (this.checkPortAndUpdate(upPart) && this.checkPortAndUpdate(downPart) && this.checkPortAndUpdate(northPart) && this.checkPortAndUpdate(southPart) && this.checkPortAndUpdate(westPart) && this.checkPortAndUpdate(eastPart)) {
            ((IFabricatorPart)upPart).setCoreComplete(true);
            ((IFabricatorPart)downPart).setCoreComplete(true);
            ((IFabricatorPart)northPart).setCoreComplete(true);
            ((IFabricatorPart)southPart).setCoreComplete(true);
            ((IFabricatorPart)westPart).setCoreComplete(true);
            ((IFabricatorPart)eastPart).setCoreComplete(true);
            this.isStructureComplete = true;
        } else {
            this.isStructureComplete = false;
            this.inputPart.clear();
            this.outputPart = null;
            this.scrapPart = null;
        }
    }

    private boolean checkPortAndUpdate(TileEntity te) {
        if (te != null && te instanceof IFabricatorPart) {
            IFabricatorPart port = (IFabricatorPart)te;
            port.setCore(new Vec3d((Vec3i)this.field_174879_c));
            port.setCoreComplete(false);
            switch (port.getModuleType()) {
                case Input: {
                    this.inputPart.add(port);
                    break;
                }
                case Tank: {
                    this.outputPart = port;
                    break;
                }
                case Scrap: {
                    this.scrapPart = port;
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.scrapFuel = compound.func_74762_e("scrapFuel");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound nbtTagCompound = super.func_189515_b(compound);
        nbtTagCompound.func_74768_a("scrapFuel", this.scrapFuel);
        return nbtTagCompound;
    }
}

