/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.block.tileentity.OilRig;

import ic2.core.block.TileEntityBlock;
import ic2.core.util.LiquidUtil;
import java.util.ArrayList;
import java.util.Vector;
import net.lrsoft.mets.block.tileentity.OilRig.IOilRig;
import net.lrsoft.mets.block.tileentity.OilRig.IOilRigCore;
import net.lrsoft.mets.block.tileentity.OilRig.TileEntityOilRigInput;
import net.lrsoft.mets.manager.BlockManager;
import net.lrsoft.mets.manager.FluidManager;
import net.lrsoft.mets.util.MathUtils;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityDimensionOilRigCore
extends TileEntityBlock
implements IOilRigCore {
    private int currentTick = 0;
    private boolean isStructureComplete = false;
    private IOilRig inputPart = null;
    private IOilRig panelPart = null;
    private Vector<IOilRig> outputPart = new Vector();
    private int offsetX = 0;
    private int offsetY = 0;
    private int offsetZ = 0;
    private int offsetMode = 0;
    private int offsetValue = 1;
    private int offsetMoveTimes = 0;
    private boolean offsetFlag = false;
    private boolean offsetUseTwice = false;
    private boolean isRigFinish = false;
    private boolean isTankFull = false;
    private boolean haveEnergy = false;
    private boolean isFirstRun = true;
    private Vec3d tempCoord = new Vec3d(0.0, -2.0, 0.0);

    protected void updateEntityServer() {
        super.updateEntityServer();
        if (this.currentTick % 30 == 0) {
            this.checkStructureComplete();
        }
        if (this.currentTick % 20 == 0 && this.isStructureComplete) {
            if (this.inputPart != null && this.outputPart.size() > 0) {
                TileEntityOilRigInput input = (TileEntityOilRigInput)this.inputPart;
                if (input.canUseEnergy(2000.0)) {
                    if (this.tryDrill()) {
                        boolean haveFillSuccess = false;
                        for (IOilRig outputSlot : this.outputPart) {
                            TileEntity output = (TileEntity)outputSlot;
                            int amount = LiquidUtil.fillTile((TileEntity)output, (EnumFacing)this.getFacing(), (FluidStack)new FluidStack(FluidManager.crudeOil, 100), (boolean)false);
                            if (amount <= 0) continue;
                            input.comsumeEnergy((double)amount / 100.0 * 2000.0);
                            haveFillSuccess = true;
                            break;
                        }
                    } else {
                        input.comsumeEnergy(1000.0);
                    }
                    this.updatePanelInfo(true);
                    this.haveEnergy = true;
                } else {
                    this.haveEnergy = false;
                }
            } else {
                this.isStructureComplete = false;
                this.updatePanelInfo(false);
            }
        }
        ++this.currentTick;
    }

    protected boolean tryDrill() {
        Vec3d targetCoord = new Vec3d(0.0, -2.0, 0.0);
        if (this.offsetFlag) {
            this.offsetY = 0;
            switch (this.offsetMode) {
                case 0: {
                    --this.offsetZ;
                    break;
                }
                case 1: {
                    --this.offsetX;
                    break;
                }
                case 2: {
                    ++this.offsetZ;
                    break;
                }
                case 3: {
                    ++this.offsetX;
                    break;
                }
            }
            this.offsetFlag = false;
        }
        targetCoord = targetCoord.func_72441_c((double)(-this.offsetX), (double)(-this.offsetY), (double)(-this.offsetZ));
        targetCoord = targetCoord.func_178787_e(new Vec3d((Vec3i)this.field_174879_c));
        this.tempCoord = new Vec3d(targetCoord.field_72450_a, targetCoord.field_72448_b, targetCoord.field_72449_c);
        Block blockTemp = this.field_145850_b.func_180495_p(new BlockPos(targetCoord)).func_177230_c();
        if (blockTemp != Blocks.field_150350_a) {
            ++this.offsetY;
            if (blockTemp == Blocks.field_150357_h) {
                if (!this.isFirstRun) {
                    if (this.offsetMoveTimes + 1 < this.offsetValue) {
                        ++this.offsetMoveTimes;
                    } else {
                        this.offsetMoveTimes = 0;
                        this.offsetMode = this.offsetMode + 1 < 4 ? ++this.offsetMode : 0;
                        if (this.offsetUseTwice) {
                            ++this.offsetValue;
                            this.offsetUseTwice = false;
                        } else {
                            this.offsetUseTwice = true;
                        }
                    }
                } else {
                    this.isFirstRun = false;
                }
                this.offsetFlag = true;
                return false;
            }
            if (blockTemp.func_149739_a().contains("ore") || blockTemp.func_149739_a().contains("Ore") || blockTemp == Blocks.field_150353_l || blockTemp == Blocks.field_150356_k) {
                this.field_145850_b.func_180501_a(new BlockPos(targetCoord), Blocks.field_150350_a.func_176223_P(), 2);
                return MathUtils.getChance(80);
            }
            if (blockTemp == Blocks.field_150343_Z) {
                this.field_145850_b.func_180501_a(new BlockPos(targetCoord), Blocks.field_150350_a.func_176223_P(), 2);
                return MathUtils.getChance(95);
            }
            if (blockTemp == Blocks.field_150351_n || blockTemp == Blocks.field_150354_m) {
                this.field_145850_b.func_180501_a(new BlockPos(targetCoord), Blocks.field_150350_a.func_176223_P(), 2);
                return MathUtils.getChance(10);
            }
            this.field_145850_b.func_180501_a(new BlockPos(targetCoord), Blocks.field_150350_a.func_176223_P(), 2);
            return MathUtils.getChance(20);
        }
        ++this.offsetY;
        return false;
    }

    private void updatePanelInfo(boolean isWorking) {
        if (this.panelPart != null) {
            TileEntityBlock te = (TileEntityBlock)this.panelPart;
            te.setActive(isWorking);
        }
    }

    @Override
    public Vec3d getRigCoordinate() {
        return this.tempCoord;
    }

    @Override
    public int getCoreState() {
        if (!this.isStructureComplete) {
            return 1;
        }
        if (!this.haveEnergy) {
            return -1;
        }
        if (this.isRigFinish) {
            return 2;
        }
        return 3;
    }

    private void checkStructureComplete() {
        TileEntity frontPart = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(1, 0, 0));
        TileEntity backPart = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-1, 0, 0));
        TileEntity leftPart = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, 1));
        TileEntity rightPart = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, -1));
        TileEntity frontLeftPart = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(1, 0, 1));
        TileEntity frontRightPart = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(1, 0, -1));
        TileEntity backLeftart = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-1, 0, 1));
        TileEntity backRightPart = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-1, 0, -1));
        TileEntity centerTop = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 1, 0));
        TileEntity centerTopest = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 2, 0));
        Vector<TileEntity> frontFlank = new Vector<TileEntity>();
        frontFlank.add(this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(2, -1, 2)));
        frontFlank.add(this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(2, -1, 1)));
        frontFlank.add(this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(2, -1, 0)));
        frontFlank.add(this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(2, -1, -1)));
        frontFlank.add(this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(2, -1, -2)));
        frontFlank.add(this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-2, -1, 2)));
        frontFlank.add(this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-2, -1, 1)));
        frontFlank.add(this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-2, -1, 0)));
        frontFlank.add(this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-2, -1, -1)));
        frontFlank.add(this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-2, -1, -2)));
        frontFlank.add(this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(2, -1, 2)));
        frontFlank.add(this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(1, -1, 2)));
        frontFlank.add(this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, -1, 2)));
        frontFlank.add(this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-1, -1, 2)));
        frontFlank.add(this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-2, -1, 2)));
        frontFlank.add(this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(2, -1, -2)));
        frontFlank.add(this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(1, -1, -2)));
        frontFlank.add(this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, -1, -2)));
        frontFlank.add(this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-1, -1, -2)));
        frontFlank.add(this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-2, -1, -2)));
        if (this.checkPortAndUpdate(frontPart) && this.checkPortAndUpdate(backPart) && this.checkPortAndUpdate(leftPart) && this.checkPortAndUpdate(rightPart) && this.checkPortAndUpdate(frontLeftPart) && this.checkPortAndUpdate(frontRightPart) && this.checkPortAndUpdate(backLeftart) && this.checkPortAndUpdate(backRightPart) && this.checkPortAndUpdate(centerTop) && this.checkPortAndUpdate(centerTopest) && this.checkPortAndUpdate(frontFlank)) {
            ((IOilRig)frontPart).setStructureComplete(true);
            ((IOilRig)backPart).setStructureComplete(true);
            ((IOilRig)leftPart).setStructureComplete(true);
            ((IOilRig)rightPart).setStructureComplete(true);
            ((IOilRig)frontLeftPart).setStructureComplete(true);
            ((IOilRig)frontRightPart).setStructureComplete(true);
            ((IOilRig)backLeftart).setStructureComplete(true);
            ((IOilRig)backRightPart).setStructureComplete(true);
            ((IOilRig)centerTop).setStructureComplete(true);
            ((IOilRig)centerTopest).setStructureComplete(true);
            for (TileEntity flankTileEntity : frontFlank) {
                ((IOilRig)flankTileEntity).setStructureComplete(true);
            }
            this.isStructureComplete = this.checkExtraPart();
        } else {
            this.isStructureComplete = false;
            this.updatePanelInfo(false);
            this.outputPart.clear();
        }
    }

    private boolean checkExtraPart() {
        int offset;
        boolean result = true;
        ArrayList<Block> scaffoldList = new ArrayList<Block>();
        for (offset = 0; offset < 4; ++offset) {
            scaffoldList.add(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, 3 + offset, 0)).func_177230_c());
        }
        scaffoldList.add(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, 5, 0)).func_177230_c());
        scaffoldList.add(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, 5, 0)).func_177230_c());
        scaffoldList.add(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, 5, 1)).func_177230_c());
        scaffoldList.add(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, 5, -1)).func_177230_c());
        scaffoldList.add(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(3, 0, 0)).func_177230_c());
        scaffoldList.add(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-3, 0, 0)).func_177230_c());
        scaffoldList.add(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, 0, 3)).func_177230_c());
        scaffoldList.add(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, 0, -3)).func_177230_c());
        scaffoldList.add(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(2, 1, 0)).func_177230_c());
        scaffoldList.add(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-2, 1, 0)).func_177230_c());
        scaffoldList.add(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, 1, 2)).func_177230_c());
        scaffoldList.add(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, 1, -2)).func_177230_c());
        for (offset = 0; offset < 2; ++offset) {
            scaffoldList.add(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, 1 + offset, 0)).func_177230_c());
        }
        for (offset = 0; offset < 2; ++offset) {
            scaffoldList.add(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, 1 + offset, 0)).func_177230_c());
        }
        for (offset = 0; offset < 2; ++offset) {
            scaffoldList.add(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, 1 + offset, 1)).func_177230_c());
        }
        for (offset = 0; offset < 2; ++offset) {
            scaffoldList.add(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, 1 + offset, -1)).func_177230_c());
        }
        for (Block block : scaffoldList) {
            if (block != Blocks.field_150350_a && block == BlockManager.titaniumScaffold) continue;
            result = false;
            break;
        }
        return result;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound nbtTagCompound = super.func_189515_b(compound);
        nbtTagCompound.func_74768_a("offsetX", this.offsetX);
        nbtTagCompound.func_74768_a("offsetY", this.offsetY);
        nbtTagCompound.func_74768_a("offsetZ", this.offsetZ);
        nbtTagCompound.func_74768_a("offsetMode", this.offsetMode);
        nbtTagCompound.func_74768_a("offsetValue", this.offsetValue);
        nbtTagCompound.func_74757_a("offsetUseTwice", this.offsetUseTwice);
        nbtTagCompound.func_74757_a("offsetFlag", this.offsetFlag);
        nbtTagCompound.func_74768_a("offsetMoveTimes", this.offsetMoveTimes);
        nbtTagCompound.func_74757_a("isFirstRun", this.isFirstRun);
        return nbtTagCompound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.offsetX = compound.func_74762_e("offsetX");
        this.offsetY = compound.func_74762_e("offsetY");
        this.offsetZ = compound.func_74762_e("offsetZ");
        this.offsetMode = compound.func_74762_e("offsetMode");
        this.offsetValue = compound.func_74762_e("offsetValue");
        this.offsetMoveTimes = compound.func_74762_e("offsetMoveTimes");
        this.offsetUseTwice = compound.func_74767_n("offsetUseTwice");
        this.offsetFlag = compound.func_74767_n("offsetFlag");
        this.isFirstRun = compound.func_74767_n("isFirstRun");
    }

    private boolean checkPortAndUpdate(TileEntity te) {
        if (te != null && te instanceof IOilRig) {
            IOilRig port = (IOilRig)te;
            port.setCore(this.field_174879_c);
            port.setStructureComplete(false);
            if (port.getModuleType() == IOilRig.ModuleType.Input) {
                this.inputPart = port;
            } else if (port.getModuleType() == IOilRig.ModuleType.Output) {
                this.outputPart.add(port);
            } else if (port.getModuleType() == IOilRig.ModuleType.Panel) {
                this.panelPart = port;
            }
            return true;
        }
        return false;
    }

    private boolean checkPortAndUpdate(Vector<TileEntity> te) {
        boolean result = true;
        for (TileEntity tileEntity : te) {
            if (this.checkPortAndUpdate(tileEntity)) continue;
            result = false;
        }
        return result;
    }
}

