/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.block.tileentity.OilRig;

import ic2.api.network.NetworkHelper;
import ic2.core.init.Localization;
import net.lrsoft.mets.block.tileentity.OilRig.IOilRig;
import net.lrsoft.mets.block.tileentity.OilRig.IOilRigCore;
import net.lrsoft.mets.block.tileentity.OilRig.TileEntityGUIMachine;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class TileEntityOilRigPanel
extends TileEntityGUIMachine
implements IOilRig {
    private BlockPos coreCoord = null;
    private boolean isStructureCompleled = false;
    private boolean haveInfoUpdate = false;
    private int tick = 0;
    private int tipState = 1;
    private int digX = -1;
    private int digY = -1;
    private int digZ = -1;

    public TileEntityOilRigPanel() {
        super(0, 3);
    }

    protected void updateEntityServer() {
        super.updateEntityServer();
        this.updateTileEntity();
    }

    private void updateTileEntity() {
        if (this.isStructureCompleled) {
            if (this.tick % 15 == 0) {
                TileEntity te = this.field_145850_b.func_175625_s(this.coreCoord);
                if (te != null && te instanceof IOilRigCore) {
                    IOilRigCore core = (IOilRigCore)te;
                    Vec3d coord = core.getRigCoordinate();
                    this.digX = (int)coord.field_72450_a;
                    this.digY = (int)coord.field_72448_b;
                    this.digZ = (int)coord.field_72449_c;
                    this.tipState = core.getCoreState();
                } else {
                    this.digZ = -1;
                    this.digY = -1;
                    this.digX = -1;
                    this.tipState = 1;
                }
                this.updateNetworkInfo();
            }
        } else {
            this.digZ = -1;
            this.digY = -1;
            this.digX = -1;
            this.tipState = 1;
            if (!this.haveInfoUpdate) {
                this.updateNetworkInfo();
                this.haveInfoUpdate = true;
            }
        }
        ++this.tick;
    }

    private void updateNetworkInfo() {
        NetworkHelper.updateTileEntityField((TileEntity)this, (String)"digX");
        NetworkHelper.updateTileEntityField((TileEntity)this, (String)"digY");
        NetworkHelper.updateTileEntityField((TileEntity)this, (String)"digZ");
        NetworkHelper.updateTileEntityField((TileEntity)this, (String)"tipState");
    }

    @Override
    public void setCore(BlockPos coord) {
        this.coreCoord = coord;
    }

    @Override
    public void setStructureComplete(boolean isCompleted) {
        this.isStructureCompleled = isCompleted;
        if (isCompleted) {
            this.haveInfoUpdate = false;
        }
    }

    @Override
    public IOilRig.ModuleType getModuleType() {
        return IOilRig.ModuleType.Panel;
    }

    public String getCoordInfo() {
        return String.format("X:%d Y:%d Z:%d", this.digX, this.digY, this.digZ);
    }

    public String getCoreInfo() {
        switch (this.tipState) {
            case -1: {
                return Localization.translate((String)"mets.info.rig.noenergy");
            }
            case 2: {
                return Localization.translate((String)"mets.info.rig.finish");
            }
            case 3: {
                return Localization.translate((String)"mets.info.rig.working");
            }
        }
        return Localization.translate((String)"mets.info.rig.structure_incompleted");
    }
}

