/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.block.tileentity;

import java.util.List;
import net.lrsoft.mets.block.tileentity.OilRig.TileEntityGUIMachine;
import net.lrsoft.mets.block.tileentity.TileEntiyLaserTower;
import net.lrsoft.mets.entity.EntityGunBullet;
import net.lrsoft.mets.manager.ConfigManager;
import net.lrsoft.mets.manager.SoundManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class TileEntityAdvancedLaserTower
extends TileEntityGUIMachine {
    private static double attackConsume = ConfigManager.AdvancedLaserTowerCost;
    private Vec3d shootOffset = new Vec3d(0.5, 1.0, 0.5);
    private static int maxEnergy = 500000;
    private static int tier = 3;
    private static int maxLockTarget = 5;
    private int scanRange = 30;
    private int updateInterval = 25;
    private int currentInterval = 0;

    public TileEntityAdvancedLaserTower() {
        super(maxEnergy, tier);
    }

    protected void updateEntityServer() {
        super.updateEntityServer();
        this.updateTileEntity();
    }

    private void updateTileEntity() {
        boolean shouldActive = false;
        if (this.energy.canUseEnergy(attackConsume)) {
            shouldActive = true;
            ++this.currentInterval;
            if (this.currentInterval >= this.updateInterval) {
                Vec3d currentPos = new Vec3d((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
                currentPos = currentPos.func_178787_e(this.shootOffset);
                AxisAlignedBB bb = new AxisAlignedBB(currentPos.field_72450_a - (double)this.scanRange, currentPos.field_72448_b - (double)this.scanRange, currentPos.field_72449_c - (double)this.scanRange, currentPos.field_72450_a + (double)this.scanRange, currentPos.field_72448_b + (double)this.scanRange, currentPos.field_72449_c + (double)this.scanRange);
                List list = this.field_145850_b.func_175674_a(null, bb, TileEntiyLaserTower.ALIVE_MOB_SELECTOR);
                if (!list.isEmpty() && this.energy.useEnergy(attackConsume)) {
                    int currentSize = list.size();
                    int maxSize = currentSize >= maxLockTarget ? maxLockTarget : currentSize;
                    for (int index = 0; index < maxSize; ++index) {
                        Entity mob = (Entity)list.get(index);
                        double yOffset = mob.func_70047_e();
                        Vec3d mobPos = new Vec3d(mob.field_70165_t, mob.field_70163_u + yOffset, mob.field_70161_v);
                        mobPos = mobPos.func_178788_d(currentPos);
                        double vecLength = mobPos.func_72433_c();
                        double tVecLength = 1.0 - vecLength;
                        tVecLength *= tVecLength;
                        Vec3d motion = new Vec3d(mobPos.field_72450_a / vecLength * tVecLength, mobPos.field_72448_b / vecLength * tVecLength, mobPos.field_72449_c / vecLength * tVecLength);
                        EntityGunBullet bullet = new EntityGunBullet(this.field_145850_b, currentPos, 40.0f, 420, true);
                        bullet.func_70186_c(motion.field_72450_a, motion.field_72448_b, motion.field_72449_c, 3.0f, 0.0f);
                        this.field_145850_b.func_72838_d((Entity)bullet);
                    }
                    this.field_145850_b.func_184148_a((EntityPlayer)null, currentPos.field_72450_a, currentPos.field_72448_b, currentPos.field_72449_c, SoundManager.laser_bullet_shoot, SoundCategory.AMBIENT, 0.6f, 0.8f);
                }
                this.currentInterval = 0;
            }
        } else {
            this.currentInterval = 0;
        }
        this.setActive(shouldActive);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("shootInterval", this.currentInterval);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.currentInterval = tag.func_74762_e("shootInterval");
    }
}

