/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.block.tileentity;

import ic2.core.IC2;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.init.MainConfig;
import ic2.core.network.GuiSynced;
import ic2.core.util.BiomeUtil;
import ic2.core.util.Config;
import ic2.core.util.ConfigUtil;
import ic2.core.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TileEntityAdvancedSolarGenerator
extends TileEntityBaseGenerator {
    private int ticker = IC2.random.nextInt(128);
    private static final int tickRate = 128;
    private static final double energyMultiplier = 64.0 * ConfigUtil.getDouble((Config)MainConfig.get(), (String)"balance/energy/generator/solar");
    @GuiSynced
    public float skyLight;

    public TileEntityAdvancedSolarGenerator() {
        super(64.0, 2, 200000);
    }

    public boolean gainEnergy() {
        if (++this.ticker % 128 == 0) {
            this.updateSunVisibility();
        }
        if (this.skyLight > 0.0f) {
            this.energy.addEnergy(energyMultiplier * (double)this.skyLight);
            return true;
        }
        return false;
    }

    public boolean gainFuel() {
        return false;
    }

    public void updateSunVisibility() {
        this.skyLight = TileEntityAdvancedSolarGenerator.getSkyLight(this.func_145831_w(), this.field_174879_c.func_177984_a());
    }

    public static float getSkyLight(World world, BlockPos pos) {
        if (world.field_73011_w.func_177495_o()) {
            return 0.1f;
        }
        float sunBrightness = Util.limit((float)((float)Math.cos(world.func_72929_e(1.0f)) * 2.0f + 0.2f), (float)0.0f, (float)1.0f);
        if (!BiomeDictionary.hasType((Biome)BiomeUtil.getBiome((World)world, (BlockPos)pos), (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
            sunBrightness *= 1.0f - world.func_72867_j(1.0f) * 5.0f / 16.0f;
            sunBrightness *= 1.0f - world.func_72819_i(1.0f) * 5.0f / 16.0f;
            sunBrightness = Util.limit((float)sunBrightness, (float)0.0f, (float)1.0f);
        }
        if (sunBrightness == 0.0f) {
            sunBrightness = 0.1f;
        }
        return (float)world.func_175642_b(EnumSkyBlock.SKY, pos) / 15.0f * sunBrightness;
    }

    public boolean needsFuel() {
        return false;
    }

    public boolean getGuiState(String name) {
        if ("sunlight".equals(name)) {
            return this.skyLight > 0.0f;
        }
        return super.getGuiState(name);
    }

    protected boolean delayActiveUpdate() {
        return true;
    }
}

