/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.block.tileentity;

import ic2.api.recipe.ILiquidAcceptManager;
import ic2.api.recipe.ISemiFluidFuelManager;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.comp.Fluids;
import ic2.core.block.comp.TileEntityComponent;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByManager;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.network.GuiSynced;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.lrsoft.mets.util.SpecialRecipesHelper;
import net.lrsoft.mets.util.VersionHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityDieselGenerator
extends TileEntityBaseGenerator {
    public InvSlotConsumableLiquid fluidSlot;
    public InvSlotOutput outputSlot;
    @GuiSynced
    protected final FluidTank fluidTank;
    protected final Fluids fluids = (Fluids)this.addComponent((TileEntityComponent)new Fluids((TileEntityBlock)this));

    public TileEntityDieselGenerator() {
        super(512.0, 3, 1000000);
        this.fluidTank = this.fluids.addTankInsert("fluid", 240000, Fluids.fluidPredicate((ILiquidAcceptManager)SpecialRecipesHelper.dieselGeneratorAcceptManager));
        try {
            Class slotClass = VersionHelper.getTargetItemSlotClass();
            this.fluidSlot = (InvSlotConsumableLiquid)InvSlotConsumableLiquidByManager.class.getConstructor(slotClass, String.class, Integer.TYPE, ILiquidAcceptManager.class).newInstance(slotClass.cast((Object)this), "fluidSlot", 1, SpecialRecipesHelper.dieselGeneratorAcceptManager);
            this.outputSlot = (InvSlotOutput)InvSlotOutput.class.getConstructor(slotClass, String.class, Integer.TYPE).newInstance(slotClass.cast((Object)this), "output", 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.fluidSlot.processIntoTank((IFluidTank)this.fluidTank, this.outputSlot)) {
            this.func_70296_d();
        }
    }

    public boolean gainFuel() {
        boolean dirty = false;
        FluidStack ret = this.fluidTank.drain(Integer.MAX_VALUE, false);
        if (ret != null) {
            if (VersionHelper.getIsFiuldNewVersion()) {
                try {
                    dirty = this.gainFuelNew(ret);
                }
                catch (Exception expt) {
                    System.out.println("[METS]:Incompatible IC2 version.\n");
                    expt.printStackTrace();
                }
            } else {
                try {
                    dirty = this.gainFuelOld(ret);
                }
                catch (Exception expt) {
                    System.out.println("[METS]:Incompatible IC2 version.\n");
                    expt.printStackTrace();
                }
            }
        }
        return dirty;
    }

    private boolean gainFuelOld(FluidStack stack) throws Exception {
        Class<?> burnPropertyClass = Class.forName("ic2.api.recipe.ISemiFluidFuelManager$BurnProperty");
        Method getBurnPropertyMethod = ISemiFluidFuelManager.class.getMethod("getBurnProperty", Fluid.class);
        Object burnPropertyObject = getBurnPropertyMethod.invoke((Object)SpecialRecipesHelper.dieselGeneratorAcceptManager, stack.getFluid());
        if (burnPropertyObject != null) {
            Object castBurnPropertyObject = burnPropertyClass.cast(burnPropertyObject);
            Field amountField = burnPropertyClass.getDeclaredField("amount");
            Field powerField = burnPropertyClass.getDeclaredField("power");
            int amount = amountField.getInt(castBurnPropertyObject);
            double power = powerField.getDouble(castBurnPropertyObject);
            int rate = 0;
            if (stack.amount >= amount * 3) {
                rate = 3;
            } else if (stack.amount < amount * 3 && stack.amount >= amount * 2) {
                rate = 2;
            } else if (stack.amount < amount * 2 && stack.amount >= amount) {
                rate = 1;
            }
            this.fluidTank.drainInternal(amount * rate, true);
            this.production = power * 1.5 * (double)rate;
            this.fuel += amount * rate;
            return rate > 0;
        }
        return false;
    }

    private boolean gainFuelNew(FluidStack stack) throws Exception {
        Class<?> fuelPropertyClass = Class.forName("ic2.api.recipe.ISemiFluidFuelManager$FuelProperty");
        Method getFuelPropertyMethod = ISemiFluidFuelManager.class.getMethod("getFuelProperty", Fluid.class);
        Object fuelPropertyObject = getFuelPropertyMethod.invoke((Object)SpecialRecipesHelper.dieselGeneratorAcceptManager, stack.getFluid());
        if (fuelPropertyObject != null) {
            long energyPerTick;
            Object castFuelPropertyObject = fuelPropertyClass.cast(fuelPropertyObject);
            Field energyPerMbField = fuelPropertyClass.getDeclaredField("energyPerMb");
            Field energyPerTickField = fuelPropertyClass.getDeclaredField("energyPerTick");
            long energyPerMb = energyPerMbField.getLong(castFuelPropertyObject);
            int toBeConsumed = energyPerMb >= (energyPerTick = energyPerTickField.getLong(castFuelPropertyObject)) ? 1 : (int)Math.ceil(energyPerTick / energyPerMb);
            if (stack.amount >= (toBeConsumed = Math.min(toBeConsumed, stack.amount))) {
                this.fluidTank.drainInternal(toBeConsumed, true);
                this.production = (double)energyPerTick * 1.5;
                this.fuel = (int)((long)this.fuel + (long)toBeConsumed * energyPerMb);
                return true;
            }
        }
        return false;
    }

    public String getOperationSoundFile() {
        return "Generators/GeothermalLoop.ogg";
    }
}

