/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.block.tileentity;

import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import java.util.List;
import net.lrsoft.mets.block.tileentity.IMets;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityDropGenerator
extends TileEntityBaseGenerator
implements IMets {
    public TileEntityDropGenerator() {
        super(20.0, 2, 10000);
    }

    protected void updateEntityServer() {
        super.updateEntityServer();
        this.updateEntity();
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateEntityClient() {
        super.updateEntityClient();
        this.updateEntity();
    }

    private void updateEntity() {
        Vec3i offset = new Vec3i(3, 3, 3);
        BlockPos minPos = this.field_174879_c.func_177973_b(offset);
        BlockPos maxPos = this.field_174879_c.func_177971_a(offset);
        AxisAlignedBB bb = new AxisAlignedBB(minPos, maxPos);
        List list = this.field_145850_b.func_72872_a(EntityItem.class, bb);
        for (Entity entity : list) {
            double d3;
            double d2;
            if (!(entity instanceof EntityItem)) continue;
            EntityItem entityItem = (EntityItem)entity;
            ItemStack currentItem = entityItem.func_92059_d();
            EnumRarity itemRarity = currentItem.func_77953_t();
            double dist = this.field_174879_c.func_177954_c(entityItem.field_70165_t - 0.5, entityItem.field_70163_u - 0.5, entityItem.field_70161_v - 0.5);
            if (dist <= 1.0) {
                int itemValue = 0;
                switch (itemRarity) {
                    case COMMON: {
                        itemValue = 20;
                        break;
                    }
                    case UNCOMMON: {
                        itemValue = 400;
                        break;
                    }
                    case EPIC: {
                        itemValue = 5000;
                        break;
                    }
                    case RARE: {
                        itemValue = 10000;
                    }
                }
                this.fuel += itemValue;
                currentItem.func_190920_e(currentItem.func_190916_E() - 1);
                entityItem.func_92058_a(currentItem);
                continue;
            }
            double d1 = ((double)this.field_174879_c.func_177958_n() - entityItem.field_70165_t + 0.5) / 8.0;
            double d4 = Math.sqrt(d1 * d1 + (d2 = ((double)this.field_174879_c.func_177956_o() - entityItem.field_70163_u + 0.5) / 8.0) * d2 + (d3 = ((double)this.field_174879_c.func_177952_p() - entityItem.field_70161_v + 0.5) / 8.0) * d3);
            double d5 = 1.0 - d4;
            if (!(d5 > 0.0)) continue;
            d5 *= d5;
            entityItem.field_70159_w += d1 / d4 * d5 * 0.05;
            entityItem.field_70181_x += d2 / d4 * d5 * 0.05;
            entityItem.field_70179_y += d3 / d4 * d5 * 0.05;
        }
    }

    public String getOperationSoundFile() {
        return "Generators/GeneratorLoop.ogg";
    }

    public boolean isConverting() {
        return this.fuel > 0;
    }

    public boolean gainFuel() {
        if (this.fuel > 0) {
            --this.fuel;
            return true;
        }
        return false;
    }
}

