/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.block.tileentity;

import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import net.lrsoft.mets.manager.BlockManager;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeHell;
import net.minecraft.world.biome.BiomeHills;

public class TileEntityGeomagneticGenerator
extends TileEntityBaseGenerator {
    private int currentTick = 0;
    private float lastSourceValue = 0.0f;
    private boolean shouldMachineWork = false;

    public TileEntityGeomagneticGenerator() {
        super(30720.0, 6, 400000000);
    }

    protected void updateEntityServer() {
        super.updateEntityServer();
        this.updateEntity();
    }

    private void updateEntity() {
        this.shouldMachineWork = this.checkStructureCompleted();
        if (this.shouldMachineWork) {
            int newFuel;
            Biome biome = this.field_145850_b.func_180494_b(this.field_174879_c);
            float ratio = this.getMagneticSource();
            if (biome instanceof BiomeHell || biome instanceof BiomeHills) {
                ratio *= 1.2f;
            }
            this.fuel = this.fuel + (newFuel = (int)ratio * 6) <= Integer.MAX_VALUE ? (this.fuel += newFuel) : Integer.MAX_VALUE;
            this.setActive(true);
        } else {
            this.setActive(false);
        }
        this.currentTick = this.currentTick + 1 < Integer.MAX_VALUE ? ++this.currentTick : 0;
    }

    private float getMagneticSource() {
        if (this.lastSourceValue != 0.0f && this.currentTick % 15 != 0) {
            return this.lastSourceValue;
        }
        float source = 1.0f;
        int seaLevelDelta = this.field_174879_c.func_177956_o() - this.field_145850_b.func_181545_F();
        if (seaLevelDelta < 0) {
            source = (float)this.field_174879_c.func_177956_o() / (float)(this.field_145850_b.func_181545_F() + 1);
        }
        int baseDelta = this.field_174879_c.func_177956_o() >= 20 ? 20 : this.field_174879_c.func_177956_o() - 0;
        int airBlockCount = 0;
        for (int i = 0; i < baseDelta; ++i) {
            Block tempBlock = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, -i, 0)).func_177230_c();
            if (tempBlock != Blocks.field_150350_a && tempBlock != Blocks.field_150355_j) continue;
            ++airBlockCount;
        }
        source = baseDelta != 0 ? (source *= (float)((baseDelta - airBlockCount) / baseDelta)) : 0.0f;
        this.lastSourceValue = source;
        return source;
    }

    private boolean checkStructureCompleted() {
        IBlockState topestAntenna = this.field_145850_b.func_180495_p(this.field_174879_c.func_177963_a(0.0, 2.0, 0.0));
        IBlockState midAntenna = this.field_145850_b.func_180495_p(this.field_174879_c.func_177963_a(0.0, 1.0, 0.0));
        IBlockState centerBase = this.field_145850_b.func_180495_p(this.field_174879_c.func_177963_a(0.0, -1.0, 0.0));
        IBlockState ABase = this.field_145850_b.func_180495_p(this.field_174879_c.func_177963_a(1.0, -1.0, 0.0));
        IBlockState BBase = this.field_145850_b.func_180495_p(this.field_174879_c.func_177963_a(-1.0, -1.0, 0.0));
        IBlockState CBase = this.field_145850_b.func_180495_p(this.field_174879_c.func_177963_a(0.0, -1.0, 1.0));
        IBlockState DBase = this.field_145850_b.func_180495_p(this.field_174879_c.func_177963_a(0.0, -1.0, -1.0));
        return topestAntenna.func_177230_c() == BlockManager.geomagneticAntenna && midAntenna.func_177230_c() == BlockManager.geomagneticAntenna && ABase.func_177230_c() == BlockManager.geomagneticPedestal && BBase.func_177230_c() == BlockManager.geomagneticPedestal && CBase.func_177230_c() == BlockManager.geomagneticPedestal && DBase.func_177230_c() == BlockManager.geomagneticPedestal;
    }

    public String getOperationSoundFile() {
        return "Generators/GeneratorLoop.ogg";
    }

    public boolean isConverting() {
        return this.shouldMachineWork && this.fuel > 0;
    }

    public boolean gainFuel() {
        if (this.shouldMachineWork && this.fuel > 0) {
            --this.fuel;
            return true;
        }
        return false;
    }
}

