/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.block.tileentity;

import ic2.core.block.comp.Energy;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.block.wiring.TileEntityElectricBlock;
import java.lang.reflect.Field;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class TileEntityWirelessPowerTransmissionNode
extends TileEntityElectricMachine {
    private Vec3d targetPosition = null;
    private static int transferSpeed = 32768;

    public TileEntityWirelessPowerTransmissionNode() {
        super(transferSpeed, 6);
    }

    protected void updateEntityServer() {
        super.updateEntityServer();
        this.updateTileEntity();
    }

    private void updateTileEntity() {
        if (this.energy.canUseEnergy((double)transferSpeed)) {
            TileEntity targetTE;
            boolean shouldActive = false;
            if (this.targetPosition != null && (targetTE = this.func_145831_w().func_175625_s(new BlockPos(this.targetPosition))) != null) {
                if (targetTE instanceof TileEntityElectricMachine) {
                    TileEntityElectricMachine machine = (TileEntityElectricMachine)targetTE;
                    try {
                        Energy targetEnergy = this.getEnegryCompFromTE(machine);
                        NBTTagCompound compound = targetEnergy.writeToNbt();
                        double currentEnergy = compound.func_74769_h("storage");
                        double maxEnergy = targetEnergy.getCapacity();
                        if (currentEnergy < maxEnergy) {
                            double useage = transferSpeed;
                            if (currentEnergy + (double)transferSpeed <= maxEnergy) {
                                compound.func_74780_a("storage", currentEnergy + (double)transferSpeed);
                            } else {
                                compound.func_74780_a("storage", maxEnergy);
                                useage = maxEnergy - currentEnergy;
                            }
                            this.energy.useEnergy(useage);
                            targetEnergy.readFromNbt(compound);
                            this.spawnEnergyParticle();
                            shouldActive = true;
                        }
                    }
                    catch (Exception expt) {
                        System.out.println(expt.getMessage());
                    }
                } else if (targetTE instanceof TileEntityElectricBlock) {
                    double maxEnergy;
                    TileEntityElectricBlock electricBlock = (TileEntityElectricBlock)targetTE;
                    NBTTagCompound compound = electricBlock.energy.writeToNbt();
                    double currentEnergy = compound.func_74769_h("storage");
                    if (currentEnergy < (maxEnergy = electricBlock.energy.getCapacity())) {
                        double useage = transferSpeed;
                        if (currentEnergy + (double)transferSpeed <= maxEnergy) {
                            compound.func_74780_a("storage", currentEnergy + (double)transferSpeed);
                        } else {
                            compound.func_74780_a("storage", maxEnergy);
                            useage = maxEnergy - currentEnergy;
                        }
                        this.energy.useEnergy(useage);
                        electricBlock.energy.readFromNbt(compound);
                        this.spawnEnergyParticle();
                        shouldActive = true;
                    }
                }
            }
            this.setActive(shouldActive);
        }
    }

    private void spawnEnergyParticle() {
    }

    public Vec3d getTargetPosition() {
        return this.targetPosition;
    }

    public void setTargetPosition(Vec3d target) {
        this.targetPosition = target;
    }

    private Energy getEnegryCompFromTE(TileEntityElectricMachine te) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        Field energyField = TileEntityElectricMachine.class.getDeclaredField("energy");
        energyField.setAccessible(true);
        return (Energy)energyField.get(te);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        double x = tag.func_74769_h("targetX");
        double y = tag.func_74769_h("targetY");
        double z = tag.func_74769_h("targetZ");
        this.targetPosition = new Vec3d(x, y, z);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.targetPosition != null) {
            tag.func_74780_a("targetX", this.targetPosition.field_72450_a);
            tag.func_74780_a("targetY", this.targetPosition.field_72448_b);
            tag.func_74780_a("targetZ", this.targetPosition.field_72449_c);
        }
        return tag;
    }

    public double getEnergy() {
        return this.energy.getEnergy();
    }

    public boolean useEnergy(double amount) {
        return this.energy.useEnergy(amount);
    }
}

