/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.crop;

import ic2.api.item.IC2Items;
import ic2.api.recipe.Recipes;
import ic2.core.IC2Potion;
import ic2.core.init.Localization;
import ic2.core.item.armor.ItemArmorHazmat;
import java.util.List;
import net.lrsoft.mets.MoreElectricTools;
import net.lrsoft.mets.crop.CopperRichCrop;
import net.lrsoft.mets.crop.IronRichCrop;
import net.lrsoft.mets.crop.LeadRichCrop;
import net.lrsoft.mets.crop.TinRichCrop;
import net.lrsoft.mets.crop.TitaniumRichCrop;
import net.lrsoft.mets.crop.UraniumRichCrop;
import net.lrsoft.mets.item.crafting.ItemCraftingManager;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CropManager {
    public static Block ironRichCrop = new IronRichCrop();
    public static Block copperRichCrop = new CopperRichCrop();
    public static Block tinRichCrop = new TinRichCrop();
    public static Block titaniumRichCrop = new TitaniumRichCrop();
    public static Block uraniumRichCrop = new UraniumRichCrop();
    public static Block leadRichCrop = new LeadRichCrop();
    public static Item ironRichSeed = CropManager.getCropSeed(ironRichCrop, Blocks.field_150458_ak, "iron_rich_seed");
    public static Item copperRichSeed = CropManager.getCropSeed(copperRichCrop, Blocks.field_150458_ak, "copper_rich_seed");
    public static Item tinRichSeed = CropManager.getCropSeed(tinRichCrop, Blocks.field_150458_ak, "tin_rich_seed");
    public static Item titaniumRichSeed = CropManager.getCropSeed(titaniumRichCrop, Blocks.field_150458_ak, "titanium_rich_seed");
    public static Item uraniumRichSeed;
    public static Item leadRichSeed;

    public static void onItemInit(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)ironRichSeed);
        event.getRegistry().register((IForgeRegistryEntry)copperRichSeed);
        event.getRegistry().register((IForgeRegistryEntry)tinRichSeed);
        event.getRegistry().register((IForgeRegistryEntry)titaniumRichSeed);
        event.getRegistry().register((IForgeRegistryEntry)uraniumRichSeed);
        event.getRegistry().register((IForgeRegistryEntry)leadRichSeed);
    }

    public static void onBlockInit(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)ironRichCrop);
        event.getRegistry().register((IForgeRegistryEntry)copperRichCrop);
        event.getRegistry().register((IForgeRegistryEntry)tinRichCrop);
        event.getRegistry().register((IForgeRegistryEntry)titaniumRichCrop);
        event.getRegistry().register((IForgeRegistryEntry)uraniumRichCrop);
        event.getRegistry().register((IForgeRegistryEntry)leadRichCrop);
    }

    public static void onRecipeInit() {
        Recipes.advRecipes.addRecipe(new ItemStack(ironRichSeed), new Object[]{"EOE", "OSO", "EOE", Character.valueOf('E'), ItemCraftingManager.plant_extract, Character.valueOf('O'), IC2Items.getItem((String)"crushed", (String)"iron"), Character.valueOf('S'), Items.field_151014_N});
        Recipes.advRecipes.addRecipe(new ItemStack(copperRichSeed), new Object[]{"EOE", "OSO", "EOE", Character.valueOf('E'), ItemCraftingManager.plant_extract, Character.valueOf('O'), IC2Items.getItem((String)"crushed", (String)"copper"), Character.valueOf('S'), Items.field_151014_N});
        Recipes.advRecipes.addRecipe(new ItemStack(tinRichSeed), new Object[]{"EOE", "OSO", "EOE", Character.valueOf('E'), ItemCraftingManager.plant_extract, Character.valueOf('O'), IC2Items.getItem((String)"crushed", (String)"tin"), Character.valueOf('S'), Items.field_151014_N});
        Recipes.advRecipes.addRecipe(new ItemStack(titaniumRichSeed), new Object[]{"EOE", "OSO", "EOE", Character.valueOf('E'), ItemCraftingManager.plant_extract, Character.valueOf('O'), ItemCraftingManager.titanium_crushed, Character.valueOf('S'), Items.field_151014_N});
        Recipes.advRecipes.addRecipe(new ItemStack(leadRichSeed), new Object[]{"EOE", "OSO", "EOE", Character.valueOf('E'), ItemCraftingManager.plant_extract, Character.valueOf('O'), IC2Items.getItem((String)"crushed", (String)"lead"), Character.valueOf('S'), Items.field_151014_N});
        Recipes.advRecipes.addRecipe(new ItemStack(uraniumRichSeed), new Object[]{"AOA", "OSO", "AOA", Character.valueOf('A'), ItemCraftingManager.plant_extract, Character.valueOf('O'), IC2Items.getItem((String)"nuclear", (String)"mox"), Character.valueOf('S'), Items.field_151014_N});
    }

    public static void onModelInit() {
        ModelLoader.setCustomModelResourceLocation((Item)ironRichSeed, (int)0, (ModelResourceLocation)new ModelResourceLocation(ironRichSeed.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)copperRichSeed, (int)0, (ModelResourceLocation)new ModelResourceLocation(copperRichSeed.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)tinRichSeed, (int)0, (ModelResourceLocation)new ModelResourceLocation(tinRichSeed.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)titaniumRichSeed, (int)0, (ModelResourceLocation)new ModelResourceLocation(titaniumRichSeed.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)uraniumRichSeed, (int)0, (ModelResourceLocation)new ModelResourceLocation(uraniumRichSeed.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)leadRichSeed, (int)0, (ModelResourceLocation)new ModelResourceLocation(leadRichSeed.getRegistryName(), "inventory"));
    }

    private static Item getCropSeed(Block crop, Block place, String itemName) {
        return ((Item)new ItemSeeds(crop, place).setRegistryName("mets", itemName)).func_77655_b("mets." + itemName).func_77637_a(MoreElectricTools.CREATIVE_TAB);
    }

    static {
        leadRichSeed = CropManager.getCropSeed(leadRichCrop, Blocks.field_150458_ak, "lead_rich_seed");
        uraniumRichSeed = ((Item)new ItemSeeds(uraniumRichCrop, Blocks.field_150458_ak){

            public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
                EntityLivingBase entityLiving;
                if (entityIn instanceof EntityLivingBase && !ItemArmorHazmat.hasCompleteHazmat((EntityLivingBase)(entityLiving = (EntityLivingBase)entityIn))) {
                    IC2Potion.radiation.applyTo(entityLiving, 200, 100);
                }
            }

            public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
                tooltip.add(Localization.translate((String)"mets.info.radiation"));
            }
        }.setRegistryName("mets", "uranium_rich_seed")).func_77655_b("mets.uranium_rich_seed").func_77637_a(MoreElectricTools.CREATIVE_TAB);
    }
}

