/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.crop;

import ic2.api.item.IC2Items;
import ic2.core.IC2Potion;
import ic2.core.item.armor.ItemArmorHazmat;
import java.util.List;
import java.util.Random;
import net.lrsoft.mets.crop.CropManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class UraniumRichCrop
extends BlockBush
implements IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    private static final AxisAlignedBB[] CROPS_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};

    public UraniumRichCrop() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.func_149647_a(null);
        this.setRegistryName("mets", "uranium_rich_crop");
        this.func_149663_c("mets.crop.uranium_rich_crop");
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149649_H();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROPS_AABB[(Integer)state.func_177229_b((IProperty)this.getAgeProperty())];
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150458_ak;
    }

    protected PropertyInteger getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    protected int getAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty());
    }

    public IBlockState withAge(int age) {
        return this.func_176223_P().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty()) >= this.getMaxAge();
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int x;
        float f;
        int i;
        super.func_180650_b(worldIn, pos, state, rand);
        if (!worldIn.func_175697_a(pos, 1)) {
            return;
        }
        if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && (i = this.getAge(state)) < this.getMaxAge() && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextInt((int)(25.0f / (f = UraniumRichCrop.getGrowthChance((Block)this, worldIn, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, this.withAge(i + 1), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
        }
        if ((x = rand.nextInt(99)) > 0 && x < 30) {
            Vec3i offset = new Vec3i(2, 2, 2);
            BlockPos minPos = pos.func_177973_b(offset);
            BlockPos maxPos = pos.func_177971_a(offset);
            AxisAlignedBB bb = new AxisAlignedBB(minPos, maxPos);
            List list = worldIn.func_72872_a(EntityLivingBase.class, bb);
            for (Entity curEntity : list) {
                EntityLivingBase entityLiving;
                if (!(curEntity instanceof EntityLivingBase) || ItemArmorHazmat.hasCompleteHazmat((EntityLivingBase)(entityLiving = (EntityLivingBase)curEntity))) continue;
                IC2Potion.radiation.applyTo(entityLiving, 200, 100);
            }
        }
    }

    public void grow(World worldIn, BlockPos pos, IBlockState state) {
        int j;
        int i = this.getAge(state) + this.getBonemealAgeIncrease(worldIn);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        worldIn.func_180501_a(pos, this.withAge(i), 2);
    }

    protected int getBonemealAgeIncrease(World worldIn) {
        return 0;
    }

    protected static float getGrowthChance(Block blockIn, World worldIn, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.func_177977_b();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                IBlockState iblockstate = worldIn.func_180495_p(blockpos.func_177982_a(i, 0, j));
                if (iblockstate.func_177230_c().canSustainPlant(iblockstate, (IBlockAccess)worldIn, blockpos.func_177982_a(i, 0, j), EnumFacing.UP, (IPlantable)blockIn)) {
                    f1 = 1.0f;
                    if (iblockstate.func_177230_c().isFertile(worldIn, blockpos.func_177982_a(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.func_177978_c();
        BlockPos blockpos2 = pos.func_177968_d();
        BlockPos blockpos3 = pos.func_177976_e();
        BlockPos blockpos4 = pos.func_177974_f();
        boolean flag = blockIn == worldIn.func_180495_p(blockpos3).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4).func_177230_c();
        boolean bl = flag1 = blockIn == worldIn.func_180495_p(blockpos1).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos2).func_177230_c();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = blockIn == worldIn.func_180495_p(blockpos3.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177968_d()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos3.func_177968_d()).func_177230_c();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return (worldIn.func_175699_k(pos) >= 8 || worldIn.func_175678_i(pos)) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        int count = 2;
        for (int i = 0; i < count; ++i) {
            if (!this.isMaxAge(state)) continue;
            drops.add((Object)IC2Items.getItem((String)"nuclear", (String)"small_uranium_238"));
            int x = rand.nextInt(99);
            if (x <= 0 || x >= 40) continue;
            drops.add((Object)IC2Items.getItem((String)"nuclear", (String)"small_uranium_235"));
            x = rand.nextInt(99);
            if (x <= 0 || x >= 20) continue;
            drops.add((Object)IC2Items.getItem((String)"nuclear", (String)"small_plutonium"));
        }
        drops.add((Object)new ItemStack(this.getSeed(), 1, 0));
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.getSeed());
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return false;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if (rand.nextInt() % 2 == 0) {
            this.grow(worldIn, pos, state);
        }
    }

    protected Item getSeed() {
        return CropManager.uraniumRichSeed;
    }

    protected Item getCrop() {
        return null;
    }

    public IBlockState func_176203_a(int meta) {
        return this.withAge(meta);
    }

    public int func_176201_c(IBlockState state) {
        return this.getAge(state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }
}

