/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import net.lrsoft.mets.manager.ConfigManager;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityRocket
extends Entity {
    private static final Predicate<Entity> ROCKET_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity.func_70067_L();
        }
    }});
    private int ticksInAir = 0;
    private float power;
    private float velocity;

    public EntityRocket(World world) {
        super(world);
        this.func_70105_a(0.4f, 0.4f);
        this.power = 5.0f;
    }

    public EntityRocket(World world, float power) {
        super(world);
        this.func_70105_a(0.4f, 0.4f);
        this.power = power;
    }

    public void func_70071_h_() {
        Entity target;
        Entity entity;
        AxisAlignedBB axisalignedbb;
        super.func_70071_h_();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (iblockstate.func_185904_a() != Material.field_151579_a && (axisalignedbb = iblockstate.func_185890_d((IBlockAccess)this.field_70170_p, blockpos)) != Block.field_185506_k && axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.rangeAttack();
            Explosion explosion = new Explosion(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.power, false, ConfigManager.WeaponDamagesTerrain);
            explosion.func_77278_a();
            explosion.func_77279_a(true);
            this.func_70106_y();
            return;
        }
        ++this.ticksInAir;
        Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
        vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        if ((entity = this.findEntityOnPath(vec3d1, vec3d)) != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null && !this.field_70128_L && (target = raytraceresult.field_72308_g) != null) {
            this.rangeAttack();
            Explosion explosion = new Explosion(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.power, false, ConfigManager.WeaponDamagesTerrain);
            explosion.func_77278_a();
            explosion.func_77279_a(true);
            this.func_70106_y();
            return;
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f4 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f4) * 57.29577951308232);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, -this.field_70159_w * (double)this.velocity, -this.field_70181_x * (double)this.velocity, -this.field_70179_y * (double)this.velocity, new int[]{0});
        float f1 = 0.99f;
        this.field_70159_w *= (double)f1;
        this.field_70181_x *= (double)f1;
        this.field_70179_y *= (double)f1;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= 0.03;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }

    protected Entity findEntityOnPath(Vec3d start, Vec3d end) {
        Entity entity = null;
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), ROCKET_TARGETS);
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            Entity entity1 = (Entity)list.get(i);
            if (this.ticksInAir < 3 || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g(0.3)).func_72327_a(start, end)) == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    public void shoot(EntityPlayer shooter, float yaw, float pitch, float velocity) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70107_b(shooter.field_70165_t, shooter.field_70163_u + 1.4, shooter.field_70161_v);
        this.shoot(f, (double)f1, (double)f2, velocity);
        this.field_70159_w += shooter.field_70159_w;
        this.field_70181_x += shooter.field_70181_x;
        this.field_70179_y += shooter.field_70179_y;
        this.velocity = velocity;
    }

    private void shoot(double x, double y, double z, float velocity) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * 0.007;
        y += this.field_70146_Z.nextGaussian() * 0.007;
        z += this.field_70146_Z.nextGaussian() * 0.007;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    private void rangeAttack() {
        Vec3i offset = new Vec3i((double)this.power, (double)this.power, (double)this.power);
        BlockPos currentPos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        BlockPos minPos = currentPos.func_177973_b(offset);
        BlockPos maxPos = currentPos.func_177971_a(offset);
        AxisAlignedBB bb = new AxisAlignedBB(minPos, maxPos);
        List list = this.field_70170_p.func_175674_a((Entity)this, bb, ROCKET_TARGETS);
        for (Entity curEntity : list) {
            if (!(curEntity instanceof EntityLivingBase)) continue;
            EntityLivingBase livingBase = (EntityLivingBase)curEntity;
            livingBase.func_70097_a(DamageSource.field_76377_j, this.power * 2.0f);
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.ticksInAir = compound.func_74762_e("ticksInAir");
        this.power = compound.func_74760_g("power");
        this.velocity = compound.func_74760_g("velocity");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("ticksInAir", this.ticksInAir);
        compound.func_74776_a("power", this.power);
        compound.func_74776_a("velocity", this.velocity);
    }
}

