/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.item;

import ic2.api.item.ElectricItem;
import ic2.core.init.Localization;
import java.util.List;
import javax.annotation.Nullable;
import net.lrsoft.mets.item.UniformElectricItem;
import net.lrsoft.mets.manager.ConfigManager;
import net.lrsoft.mets.util.ItemStackUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ElectricForceFieldGenerator
extends UniformElectricItem {
    private static final double storageEnergy = 1000000.0;
    private static final double transferSpeed = 512.0;

    public ElectricForceFieldGenerator() {
        super("electric_force_field_generator", 1000000.0, 512.0, 3);
        this.func_185043_a(new ResourceLocation("mets", "storage_energy_value"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return (float)ItemStackUtils.getCurrentTex(stack, 4) / 4.0f;
            }
        });
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!(entityIn instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityIn;
        boolean shouldWork = this.getAutoSupplement(stack);
        float currentAbsAmount = player.func_110139_bj();
        if (!worldIn.field_72995_K && shouldWork && currentAbsAmount < 10.0f && ElectricItem.manager.use(stack, ConfigManager.ForceFieldCost, (EntityLivingBase)player)) {
            player.func_110149_m(currentAbsAmount + 0.5f);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        long lastRightClick = this.getLastRightClick(stack);
        long currentTime = System.currentTimeMillis();
        boolean autoSupplement = this.getAutoSupplement(stack);
        if (currentTime - lastRightClick > 100L) {
            autoSupplement = !autoSupplement;
            lastRightClick = currentTime;
            try {
                if (autoSupplement) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(Localization.translate((String)"mets.info.ens.auto")));
                } else {
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(Localization.translate((String)"mets.info.ens.disable")));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setLastRightClick(stack, lastRightClick);
            this.setAutoSupplement(stack, autoSupplement);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    private void setAutoSupplement(ItemStack stack, boolean value) {
        stack.func_77973_b().getNBTShareTag(stack).func_74757_a("AutoSupplement", value);
    }

    private boolean getAutoSupplement(ItemStack stack) {
        boolean value = false;
        try {
            value = stack.func_77973_b().getNBTShareTag(stack).func_74767_n("AutoSupplement");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(Localization.translate((String)"mets.info.extralife"));
    }
}

