/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.item;

import ic2.api.item.ElectricItem;
import ic2.core.init.Localization;
import javax.annotation.Nullable;
import net.lrsoft.mets.item.UniformElectricItem;
import net.lrsoft.mets.manager.ConfigManager;
import net.lrsoft.mets.util.ItemStackUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ElectricNutritionSupply
extends UniformElectricItem {
    private static final double storageEnergy = 10000.0;
    private static final double transferSpeed = 32.0;

    public ElectricNutritionSupply() {
        super("electric_nutrition_supply", 10000.0, 32.0, 1);
        this.func_185043_a(new ResourceLocation("mets", "storage_energy_value"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return (float)ItemStackUtils.getCurrentTex(stack, 4) / 4.0f;
            }
        });
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        EntityPlayer player;
        FoodStats foodStats;
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        boolean shouldWork = this.getAutoSupplement(stack);
        if (!worldIn.field_72995_K && shouldWork && entityIn instanceof EntityPlayer && (foodStats = (player = (EntityPlayer)entityIn).func_71024_bL()).func_75121_c()) {
            if (ElectricItem.manager.canUse(stack, ConfigManager.ElectricNutritionSupplyCost)) {
                ElectricItem.manager.use(stack, ConfigManager.ElectricNutritionSupplyCost, (EntityLivingBase)player);
                foodStats.func_75122_a(1, 0.2f);
            }
            player.field_71069_bz.func_75142_b();
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        long lastRightClick = this.getLastRightClick(stack);
        long currentTime = System.currentTimeMillis();
        boolean autoSupplement = this.getAutoSupplement(stack);
        if (currentTime - lastRightClick > 100L) {
            autoSupplement = !autoSupplement;
            lastRightClick = currentTime;
            try {
                if (autoSupplement) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(Localization.translate((String)"mets.info.ens.auto")));
                } else {
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(Localization.translate((String)"mets.info.ens.disable")));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setLastRightClick(stack, lastRightClick);
            this.setAutoSupplement(stack, autoSupplement);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    private void setAutoSupplement(ItemStack stack, boolean value) {
        stack.func_77973_b().getNBTShareTag(stack).func_74757_a("AutoSupplement", value);
    }

    private boolean getAutoSupplement(ItemStack stack) {
        boolean value = false;
        try {
            value = stack.func_77973_b().getNBTShareTag(stack).func_74767_n("AutoSupplement");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }
}

