/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.item;

import ic2.api.item.ElectricItem;
import ic2.core.init.Localization;
import net.lrsoft.mets.item.UniformElectricItem;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeHell;
import net.minecraft.world.biome.BiomeHills;

public class GeomagneticDetector
extends UniformElectricItem {
    private static final double storageEnergy = 50000.0;
    private static final double transferSpeed = 128.0;

    public GeomagneticDetector() {
        super("geomagnetic_detector", 50000.0, 128.0, 2);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack currentItem = player.func_184586_b(hand);
        TileEntity te = worldIn.func_175625_s(pos);
        if (ElectricItem.manager.canUse(currentItem, 100.0)) {
            Biome biome = worldIn.func_180494_b(pos);
            float ratio = this.getMagneticSource(worldIn, pos);
            if (biome instanceof BiomeHell || biome instanceof BiomeHills) {
                ratio *= 1.2f;
            }
            try {
                player.func_145747_a((ITextComponent)new TextComponentString(Localization.translate((String)"mets.info.geomagnetic_detector", (Object[])new Object[]{Float.valueOf(ratio)})));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    private float getMagneticSource(World worldIn, BlockPos pos) {
        float source = 1.0f;
        int seaLevelDelta = pos.func_177956_o() - worldIn.func_181545_F();
        if (seaLevelDelta < 0) {
            source = (float)pos.func_177956_o() / (float)(worldIn.func_181545_F() + 1);
        }
        int baseDelta = pos.func_177956_o() >= 20 ? 20 : pos.func_177956_o() - 0;
        int airBlockCount = 0;
        for (int i = 0; i < baseDelta; ++i) {
            Block tempBlock = worldIn.func_180495_p(pos.func_177982_a(0, -i, 0)).func_177230_c();
            if (tempBlock != Blocks.field_150350_a && tempBlock != Blocks.field_150355_j) continue;
            ++airBlockCount;
        }
        source = baseDelta != 0 ? (source *= (float)((baseDelta - airBlockCount) / baseDelta)) : 0.0f;
        return source;
    }
}

