/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.item;

import ic2.api.item.ElectricItem;
import ic2.api.item.IBoxable;
import ic2.api.item.IElectricItem;
import ic2.api.item.IItemHudInfo;
import ic2.core.item.ElectricItemManager;
import ic2.core.item.IPseudoDamageItem;
import java.util.LinkedList;
import java.util.List;
import net.lrsoft.mets.MoreElectricTools;
import net.lrsoft.mets.enchantment.EfficientEnergyCost;
import net.lrsoft.mets.manager.EnchantmentManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class UniformElectricItem
extends Item
implements IElectricItem,
IItemHudInfo,
IBoxable,
IPseudoDamageItem {
    private double maxStorageEU = 0.0;
    private double transferSpeed = 0.0;
    private int powerLevel = 0;

    public UniformElectricItem(String itemName, double maxEU, double tSpeed, int tier) {
        this.maxStorageEU = maxEU;
        this.transferSpeed = tSpeed;
        this.powerLevel = tier;
        this.func_77655_b("mets." + itemName);
        this.setRegistryName("mets", itemName);
        this.func_77637_a(MoreElectricTools.CREATIVE_TAB);
        this.func_77656_e(12345);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public List<String> getHudInfo(ItemStack stack, boolean advanced) {
        LinkedList<String> info = new LinkedList<String>();
        info.add(ElectricItem.manager.getToolTip(stack));
        return info;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxCharge(ItemStack stack) {
        return this.maxStorageEU;
    }

    public int getTier(ItemStack stack) {
        return this.powerLevel;
    }

    public double getTransferLimit(ItemStack stack) {
        return this.transferSpeed;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    protected void setLastRightClick(ItemStack stack, long value) {
        stack.func_77973_b().getNBTShareTag(stack).func_74772_a("LastRightClick", value);
    }

    protected long getLastRightClick(ItemStack stack) {
        long value = 0L;
        try {
            value = stack.func_77973_b().getNBTShareTag(stack).func_74763_f("LastRightClick");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public boolean canBeStoredInToolbox(ItemStack stack) {
        return true;
    }

    public float getElectricItemAttenuationRatio(ItemStack stack) {
        return EfficientEnergyCost.getAttenuationRatio(EnchantmentHelper.func_77506_a((Enchantment)EnchantmentManager.efficientEu, (ItemStack)stack));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == EnchantmentManager.efficientEu;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ElectricItemManager.addChargeVariants((Item)this, items);
    }

    public void setStackDamage(ItemStack stack, int damage) {
        super.setDamage(stack, damage);
    }

    public void setDamage(ItemStack stack, int damage) {
    }
}

