/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.item.battery;

import ic2.api.item.ElectricItem;
import ic2.core.init.Localization;
import ic2.core.util.StackUtil;
import javax.annotation.Nullable;
import net.lrsoft.mets.item.UniformElectricItem;
import net.lrsoft.mets.util.ItemStackUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ChargingSuperLapotronCrystal
extends UniformElectricItem {
    public static final double maxStorageEnergy = 4.0E8;
    public static final double transferSpeed = 8192.0;
    public static final int tier = 5;

    public ChargingSuperLapotronCrystal() {
        super("charging_super_lapotron_crystal", 4.0E8, 8192.0, 5);
        this.func_185043_a(new ResourceLocation("mets", "super_lapotron_crystal_value"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return (float)ItemStackUtils.getCurrentTex(stack, 4) / 4.0f;
            }
        });
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        boolean autoCharge = this.getAutoCharge(stack);
        if (entity instanceof EntityPlayerMP && world.func_82737_E() % 10L < (long)this.getTier(stack) && autoCharge) {
            EntityPlayer thePlayer = (EntityPlayer)entity;
            NonNullList nonNullList = thePlayer.field_71071_by.field_70462_a;
            double limit = 8192.0;
            for (int i = 0; i < 9 && limit > 0.0; ++i) {
                ItemStack toCharge = (ItemStack)nonNullList.get(i);
                if (StackUtil.isEmpty((ItemStack)toCharge) && i == thePlayer.field_71071_by.field_70461_c) continue;
                double charge = ElectricItem.manager.charge(toCharge, limit, 5, false, true);
                charge = ElectricItem.manager.discharge(stack, charge, 5, true, false, false);
                ElectricItem.manager.charge(toCharge, charge, 5, true, false);
                limit -= charge;
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        long lastRightClick = this.getLastRightClick(stack);
        long currentTime = System.currentTimeMillis();
        boolean autoCharge = this.getAutoCharge(stack);
        if (currentTime - lastRightClick > 100L) {
            autoCharge = !autoCharge;
            lastRightClick = currentTime;
            try {
                if (autoCharge) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(Localization.translate((String)"mets.info.ens.auto")));
                } else {
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(Localization.translate((String)"mets.info.ens.disable")));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setLastRightClick(stack, lastRightClick);
            this.setAutoCharge(stack, autoCharge);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private void setAutoCharge(ItemStack stack, boolean value) {
        stack.func_77973_b().getNBTShareTag(stack).func_74757_a("AutoCharge", value);
    }

    private boolean getAutoCharge(ItemStack stack) {
        boolean value = false;
        try {
            value = stack.func_77973_b().getNBTShareTag(stack).func_74767_n("AutoCharge");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }
}

