/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.item.bauble;

import baubles.api.BaubleType;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import java.util.Random;
import net.lrsoft.mets.item.bauble.UniformBaubleTemplate;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class ElectricFlightRing
extends UniformBaubleTemplate {
    private static final double transferSpeed = 2048.0;
    private static final double storageEnergy = 1.0E7;

    public ElectricFlightRing() {
        super("electric_flight_ring", 1.0E7, 2048.0, 4);
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.RING;
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase entity) {
        EntityPlayer player;
        if (entity instanceof EntityPlayer && !(player = (EntityPlayer)entity).func_175149_v() && !player.field_71075_bZ.field_75098_d) {
            float ratio = this.getElectricItemAttenuationRatio(itemstack);
            if (ElectricItem.manager.canUse(itemstack, (double)(10.0f * ratio))) {
                if (!player.field_71075_bZ.field_75101_c) {
                    this.enableFlyingAbility(player);
                } else if (player.field_71075_bZ.field_75100_b) {
                    if (!ElectricItem.manager.use(itemstack, (double)(10.0f * ratio), entity)) {
                        this.disableFlyingAbility(player);
                    } else if (IC2.keyboard.isBoostKeyDown(player) && ElectricItem.manager.use(itemstack, (double)(10.0f * ratio), entity)) {
                        Vec3d vec3d = player.func_70040_Z();
                        player.field_70159_w += vec3d.field_72450_a * 0.4 + (vec3d.field_72450_a * 1.5 - player.field_70159_w) * 0.5;
                        player.field_70181_x += vec3d.field_72448_b * 0.4 + (vec3d.field_72448_b * 1.5 - player.field_70181_x) * 0.5;
                        player.field_70179_y += vec3d.field_72449_c * 0.4 + (vec3d.field_72449_c * 1.5 - player.field_70179_y) * 0.5;
                        float pitch = player.field_70125_A;
                        float yaw = player.field_70177_z;
                        for (int p = 0; p < 3; ++p) {
                            float newYaw = yaw + (float)this.getRandomFromRange(40, -40);
                            float newPitch = pitch + (float)this.getRandomFromRange(40, -40);
                            Vec3d shootPosition = new Vec3d((double)(-MathHelper.func_76126_a((float)(newYaw * 0.0174f)) * MathHelper.func_76134_b((float)(newPitch * 0.0174f))), (double)(-MathHelper.func_76126_a((float)(newPitch * 0.0174f))), (double)(MathHelper.func_76134_b((float)(newYaw * 0.0174f)) * MathHelper.func_76134_b((float)(newPitch * 0.0174f))));
                            player.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, player.field_70165_t, player.field_70163_u + (double)player.func_70047_e() - (double)0.2f, player.field_70161_v, shootPosition.field_72450_a, shootPosition.field_72448_b, shootPosition.field_72449_c, new int[]{1});
                        }
                    }
                }
            } else {
                this.disableFlyingAbility(player);
            }
        }
    }

    private int getRandomFromRange(int max, int min) {
        return new Random().nextInt(max - min) + min;
    }

    private void enableFlyingAbility(EntityPlayer player) {
        player.field_71075_bZ.field_75101_c = true;
        player.field_71075_bZ.field_75100_b = false;
        player.func_71016_p();
    }

    private void disableFlyingAbility(EntityPlayer player) {
        player.field_71075_bZ.field_75101_c = false;
        player.field_71075_bZ.field_75100_b = false;
        player.func_71016_p();
    }

    @Override
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
        super.onUnequipped(itemstack, player);
        if (player instanceof EntityPlayer) {
            this.disableFlyingAbility((EntityPlayer)player);
        }
    }
}

