/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.item.bauble;

import baubles.api.BaubleType;
import ic2.api.item.ElectricItem;
import javax.annotation.Nullable;
import net.lrsoft.mets.item.bauble.UniformBaubleTemplate;
import net.lrsoft.mets.manager.ConfigManager;
import net.lrsoft.mets.util.ItemStackUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ElectricLifeSupportRing
extends UniformBaubleTemplate {
    private static final double transferSpeed = 8192.0;
    private static final double storageEnergy = 1.0E8;

    public ElectricLifeSupportRing() {
        super("electric_life_support_ring", 1.0E8, 8192.0, 5);
        this.func_185043_a(new ResourceLocation("mets", "ring_energy_value"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return (float)ItemStackUtils.getCurrentTex(stack, 4) / 4.0f;
            }
        });
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.RING;
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase entity) {
        if (!entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer) {
            float currentAbsAmount;
            FoodStats foodStats;
            EntityPlayer player = (EntityPlayer)entity;
            boolean haveInfoUpdated = false;
            float ratio = this.getElectricItemAttenuationRatio(itemstack);
            float currentHealth = player.func_110143_aJ();
            if (currentHealth < player.func_110138_aP() && ElectricItem.manager.canUse(itemstack, ConfigManager.ElectricFirstAidLifeSupport * (double)ratio)) {
                ElectricItem.manager.use(itemstack, ConfigManager.ElectricFirstAidLifeSupport * (double)ratio, (EntityLivingBase)player);
                player.func_70606_j(currentHealth + 1.0f);
                haveInfoUpdated = true;
            }
            if ((foodStats = player.func_71024_bL()).func_75121_c() && ElectricItem.manager.canUse(itemstack, ConfigManager.ElectricNutritionSupplyCost * (double)ratio)) {
                ElectricItem.manager.use(itemstack, ConfigManager.ElectricNutritionSupplyCost * (double)ratio, (EntityLivingBase)player);
                foodStats.func_75122_a(1, 0.2f);
                haveInfoUpdated = true;
            }
            if ((currentAbsAmount = player.func_110139_bj()) < 20.0f && ElectricItem.manager.canUse(itemstack, ConfigManager.ForceFieldCost * (double)ratio)) {
                ElectricItem.manager.use(itemstack, ConfigManager.ForceFieldCost * (double)ratio, (EntityLivingBase)player);
                player.func_110149_m(currentAbsAmount + 0.5f);
                haveInfoUpdated = true;
            }
            if (haveInfoUpdated) {
                player.field_71069_bz.func_75142_b();
            }
        }
    }
}

