/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.item.reactor;

import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.core.init.Localization;
import java.util.List;
import net.lrsoft.mets.MoreElectricTools;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ReactorHeatVent
extends Item
implements IReactorComponent {
    private int reactorVent = 36;
    private int selfVent = 20;
    private int maxHeat = 1000;

    public ReactorHeatVent(String itemName, int newReactorVent, int newSelfVent, int newMaxHeat) {
        this.reactorVent = newReactorVent;
        this.selfVent = newSelfVent;
        this.maxHeat = newMaxHeat;
        this.func_77625_d(64);
        this.func_77656_e(this.maxHeat);
        this.func_77655_b("mets." + itemName);
        this.setRegistryName("mets", itemName);
        this.func_77637_a(MoreElectricTools.CREATIVE_TAB);
    }

    public boolean canBePlacedIn(ItemStack stack, IReactor reactor) {
        return true;
    }

    public void processChamber(ItemStack stack, IReactor reactor, int x, int y, boolean heatrun) {
        if (heatrun) {
            int self;
            if (this.reactorVent > 0) {
                int rheat = reactor.getHeat();
                int reactorDrain = rheat;
                if (reactorDrain > this.reactorVent) {
                    reactorDrain = this.reactorVent;
                }
                rheat -= reactorDrain;
                if ((reactorDrain = this.alterHeat(stack, reactor, x, y, reactorDrain)) > 0) {
                    return;
                }
                reactor.setHeat(rheat);
            }
            if ((self = this.alterHeat(stack, reactor, x, y, -this.selfVent)) <= 0) {
                reactor.addEmitHeat(self + this.selfVent);
            }
        }
    }

    private void checkNearByItem(IReactor reactor, int x, int y) {
        ItemStack targetStack = reactor.getItemAt(x, y);
        if (targetStack != null && targetStack.func_77973_b() instanceof IReactorComponent) {
            IReactorComponent iReactorComponent = (IReactorComponent)targetStack.func_77973_b();
        }
    }

    public boolean acceptUraniumPulse(ItemStack stack, IReactor reactor, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        return false;
    }

    public boolean canStoreHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return true;
    }

    public int getMaxHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return this.getMaxDamage(stack);
    }

    public int getCurrentHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return this.getDamage(stack);
    }

    public int alterHeat(ItemStack stack, IReactor reactor, int x, int y, int heat) {
        int myHeat = this.getCurrentHeat(stack, reactor, x, y);
        int max = this.getMaxHeat(stack, reactor, x, y);
        if ((myHeat += heat) > max) {
            reactor.setItemAt(x, y, null);
            heat = max - myHeat + 1;
        } else {
            if (myHeat < 0) {
                heat = myHeat;
                myHeat = 0;
            } else {
                heat = 0;
            }
            this.setDamage(stack, myHeat);
        }
        return heat;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        tooltip.add(Localization.translate((String)"ic2.reactoritem.durability") + " " + (this.getMaxDamage(stack) - this.getDamage(stack)) + "/" + this.getMaxDamage(stack));
        if (this.getDamage(stack) > 0) {
            tooltip.add(Localization.translate((String)"ic2.reactoritem.heatwarning.line1"));
            tooltip.add(Localization.translate((String)"ic2.reactoritem.heatwarning.line2"));
        }
    }

    public float influenceExplosion(ItemStack stack, IReactor reactor) {
        return 0.0f;
    }
}

