/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.item.weapon;

import ic2.api.item.ElectricItem;
import javax.annotation.Nullable;
import net.lrsoft.mets.item.UniformElectricItem;
import net.lrsoft.mets.manager.ConfigManager;
import net.lrsoft.mets.manager.EnchantmentManager;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AdvancedIridiumSword
extends UniformElectricItem {
    private static final double maxStorageEU = 1.0E7;
    private static final double transferSpeed = 2048.0;
    private static final double sweepingDistance = 12.0;

    public AdvancedIridiumSword() {
        super("advanced_iridium_sword", 1.0E7, 2048.0, 4);
        this.func_185043_a(new ResourceLocation("mets", "iridium_sword_state"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                boolean isHyperState = AdvancedIridiumSword.this.getHyperState(stack);
                float hyperState = AdvancedIridiumSword.this.getHyperValue(stack);
                if (isHyperState) {
                    hyperState = hyperState <= 0.71f ? (hyperState += 0.002f) : 0.1f;
                    AdvancedIridiumSword.this.setHyperValue(stack, hyperState);
                    return hyperState;
                }
                return 0.0f;
            }
        });
    }

    private float getAttackDamage(ItemStack stack) {
        boolean isHyperState = this.getHyperState(stack);
        float damage = ConfigManager.AdvancedIridiumSwordBaseAttackDamage;
        if (isHyperState) {
            int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)stack);
            damage *= level == 0 ? 1.5f : (float)(level + 1);
        }
        return damage;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        float ratio;
        if (!(attacker instanceof EntityPlayer) || attacker.func_130014_f_().field_72995_K) {
            return true;
        }
        boolean isHyperState = this.getHyperState(stack);
        double attackCost = ConfigManager.AdvancedIridiumSwordBaseCost * (isHyperState ? 1.5 : 1.0) * (double)(ratio = this.getElectricItemAttenuationRatio(stack));
        if (ElectricItem.manager.canUse(stack, attackCost)) {
            ElectricItem.manager.discharge(stack, attackCost, 4, true, false, false);
            float attackDamage = this.getAttackDamage(stack);
            if (isHyperState && attacker instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)attacker;
                World currentWorld = player.func_130014_f_();
                for (EntityLivingBase entitylivingbase : currentWorld.func_72872_a(EntityLivingBase.class, target.func_174813_aQ().func_72314_b(1.0, 0.25, 1.0))) {
                    if (entitylivingbase == player || entitylivingbase == target || !(player.func_70068_e((Entity)entitylivingbase) < 12.0)) continue;
                    entitylivingbase.func_70653_a((Entity)player, 0.4f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * 0.017f)), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * 0.017f))));
                    entitylivingbase.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), attackDamage / 2.0f);
                }
                player.func_130014_f_().func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187730_dW, player.func_184176_by(), 1.0f, 1.0f);
            }
            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), attackDamage);
        }
        return true;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return super.onLeftClickEntity(stack, player, entity);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack currentSword = playerIn.func_184586_b(handIn);
        long lastRightClick = this.getLastRightClick(currentSword);
        long currentTime = System.currentTimeMillis();
        boolean isHyperState = this.getHyperState(currentSword);
        if (currentTime - lastRightClick > 100L) {
            isHyperState = !isHyperState;
            lastRightClick = currentTime;
            this.setHyperState(currentSword, isHyperState);
            this.setLastRightClick(currentSword, lastRightClick);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)currentSword);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150321_G) {
            return 18.0f;
        }
        return 1.0f;
    }

    private void setHyperState(ItemStack stack, boolean state) {
        stack.func_77973_b().getNBTShareTag(stack).func_74757_a("isHyperState", state);
    }

    private boolean getHyperState(ItemStack stack) {
        boolean value = false;
        try {
            value = stack.func_77973_b().getNBTShareTag(stack).func_74767_n("isHyperState");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    private void setHyperValue(ItemStack stack, float value) {
        stack.func_77973_b().getNBTShareTag(stack).func_74776_a("HyperValue", value);
    }

    private float getHyperValue(ItemStack stack) {
        float value = 0.0f;
        try {
            value = stack.func_77973_b().getNBTShareTag(stack).func_74760_g("HyperValue");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == EnchantmentManager.efficientEu || enchantment == Enchantments.field_185302_k;
    }
}

