/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.item.weapon;

import ic2.api.item.ElectricItem;
import net.lrsoft.mets.entity.EntityRocket;
import net.lrsoft.mets.item.UniformElectricItem;
import net.lrsoft.mets.item.crafting.ItemCraftingManager;
import net.lrsoft.mets.manager.ConfigManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ElectricRocketLauncher
extends UniformElectricItem {
    private static final double storageEnergy = 1000000.0;
    private static final double transferSpeed = 512.0;

    public ElectricRocketLauncher() {
        super("electric_rocket_launcher", 1000000.0, 512.0, 3);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack currentLauncher = playerIn.func_184586_b(handIn);
        long lastRightClick = this.getLastRightClick(currentLauncher);
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastRightClick > (long)ConfigManager.ElectricRocketLauncherInterval) {
            lastRightClick = currentTime;
            boolean isCreativeMode = playerIn.field_71075_bZ.field_75098_d;
            float ratio = this.getElectricItemAttenuationRatio(currentLauncher);
            if (ElectricItem.manager.canUse(currentLauncher, ConfigManager.ElectricRocketLauncherCost * (double)ratio) || isCreativeMode) {
                boolean shouldLaunch = false;
                if (isCreativeMode) {
                    shouldLaunch = true;
                } else {
                    ItemStack ammo = this.findAmmo(playerIn);
                    if (ammo != ItemStack.field_190927_a) {
                        ElectricItem.manager.use(currentLauncher, ConfigManager.ElectricRocketLauncherCost * (double)ratio, (EntityLivingBase)playerIn);
                        ammo.func_190920_e(ammo.func_190916_E() - 1);
                        shouldLaunch = true;
                    }
                }
                if (shouldLaunch) {
                    EntityRocket entity = new EntityRocket(worldIn, 8.0f);
                    entity.shoot(playerIn, playerIn.field_70177_z, playerIn.field_70125_A, 2.5f);
                    worldIn.func_72838_d((Entity)entity);
                    this.setLastRightClick(currentLauncher, lastRightClick);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)currentLauncher);
                }
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)currentLauncher);
    }

    protected boolean isRocket(ItemStack stack) {
        return stack.func_77973_b() == ItemCraftingManager.rocket;
    }

    private ItemStack findAmmo(EntityPlayer player) {
        if (this.isRocket(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isRocket(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isRocket(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }
}

