/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.item.weapon;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IItemHudInfo;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.lrsoft.mets.MoreElectricTools;
import net.minecraft.block.BlockDispenser;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ElectricShield
extends ItemShield
implements IElectricItem,
IItemHudInfo {
    private static final double heldCost = 100.0;

    public ElectricShield() {
        this.func_77655_b("mets.electric_shield");
        this.setRegistryName("mets", "electric_shield");
        this.func_77637_a(MoreElectricTools.CREATIVE_TAB);
        this.func_77656_e(1000);
        this.setNoRepair();
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("blocking"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)ItemArmor.field_96605_cw);
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)"mets.electric_shield.name");
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        ElectricItem.manager.use(stack, 100.0, entityLiving);
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            player.field_71069_bz.func_75142_b();
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (ElectricItem.manager.canUse(itemstack, 100.0)) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    public List<String> getHudInfo(ItemStack stack, boolean advanced) {
        LinkedList<String> info = new LinkedList<String>();
        info.add(ElectricItem.manager.getToolTip(stack));
        return info;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxCharge(ItemStack stack) {
        return 50000.0;
    }

    public int getTier(ItemStack stack) {
        return 2;
    }

    public double getTransferLimit(ItemStack stack) {
        return 128.0;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public boolean isShield(ItemStack stack, @Nullable EntityLivingBase entity) {
        return true;
    }
}

