/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.item.weapon;

import ic2.api.item.ElectricItem;
import net.lrsoft.mets.entity.EntityGunBullet;
import net.lrsoft.mets.item.UniformElectricItem;
import net.lrsoft.mets.manager.ConfigManager;
import net.lrsoft.mets.manager.SoundManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ElectricSubmachineGun
extends UniformElectricItem {
    private static final double storageEnergy = 50000.0;
    private static final double transferSpeed = 128.0;

    public ElectricSubmachineGun() {
        super("electric_submachine_gun", 50000.0, 128.0, 2);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack currentGun = playerIn.func_184586_b(handIn);
        long lastRightClick = this.getLastRightClick(currentGun);
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastRightClick > 100L) {
            lastRightClick = currentTime;
            if (ElectricItem.manager.use(currentGun, ConfigManager.ElectricSubmachineGunCost, (EntityLivingBase)playerIn)) {
                EntityGunBullet entity = new EntityGunBullet(worldIn, playerIn, 6.0f, 250);
                entity.shoot(playerIn.field_70177_z, playerIn.field_70125_A, 3.0f);
                worldIn.func_72838_d((Entity)entity);
                worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundManager.laser_bullet_shoot, playerIn.func_184176_by(), 0.1f, 0.55f);
                this.setLastRightClick(currentGun, lastRightClick);
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)currentGun);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase targetEntity, EntityLivingBase attacker) {
        if (targetEntity instanceof EntityLivingBase && attacker instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attacker;
            EntityLivingBase enemyEntity = targetEntity;
            if (ElectricItem.manager.use(stack, ConfigManager.ElectricSubmachineGunCost / 5.0, (EntityLivingBase)player)) {
                enemyEntity.func_70653_a((Entity)attacker, 0.5f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
            }
        }
        return true;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }
}

