/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.item.weapon;

import ic2.api.item.ElectricItem;
import javax.annotation.Nullable;
import net.lrsoft.mets.entity.EntityTachyonBullet;
import net.lrsoft.mets.item.UniformElectricItem;
import net.lrsoft.mets.manager.ConfigManager;
import net.lrsoft.mets.manager.SoundManager;
import net.lrsoft.mets.util.ItemStackUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TachyonDisruptor
extends UniformElectricItem {
    private static final double storageEnergy = 4.0E8;
    private static final double transferSpeed = 8192.0;

    public TachyonDisruptor() {
        super("tachyon_disruptor", 4.0E8, 8192.0, 5);
        this.func_185043_a(new ResourceLocation("mets", "energy_value"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return (float)ItemStackUtils.getCurrentTex(stack, 4) / 4.0f;
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        float ratio;
        ItemStack currentGun = playerIn.func_184586_b(handIn);
        long lastRightClick = this.getLastRightClick(currentGun);
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastRightClick > 250L && ElectricItem.manager.use(currentGun, ConfigManager.TachyonDisruptorCost * (double)(ratio = this.getElectricItemAttenuationRatio(currentGun)), (EntityLivingBase)playerIn)) {
            EntityTachyonBullet entity = new EntityTachyonBullet(worldIn, playerIn, 120.0f, 600);
            entity.shoot(playerIn.field_70177_z, playerIn.field_70125_A, 4.0f);
            worldIn.func_72838_d((Entity)entity);
            worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundManager.laser_bullet_shoot, playerIn.func_184176_by(), 0.2f, 0.4f);
            this.setLastRightClick(currentGun, currentTime);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)currentGun);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase targetEntity, EntityLivingBase attacker) {
        if (targetEntity instanceof EntityLivingBase && attacker instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attacker;
            EntityLivingBase enemyEntity = targetEntity;
            float ratio = this.getElectricItemAttenuationRatio(stack);
            if (ElectricItem.manager.use(stack, ConfigManager.TachyonDisruptorCost * (double)ratio, (EntityLivingBase)player)) {
                enemyEntity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 30, 3));
                enemyEntity.func_70653_a((Entity)attacker, 1.0f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                enemyEntity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), this.getAttackDamage(30.0f, stack));
            }
        }
        return true;
    }

    private float getAttackDamage(float damage, ItemStack stack) {
        int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)stack);
        return damage *= level == 0 ? 1.0f : (float)level * 1.25f;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        boolean value = super.canApplyAtEnchantingTable(stack, enchantment);
        if (enchantment == Enchantments.field_185302_k) {
            value = true;
        }
        return value;
    }
}

