/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.manager;

import net.lrsoft.mets.blade.EntityDriveEx;
import net.lrsoft.mets.blade.EntitySlashDimensionEx;
import net.lrsoft.mets.blade.EntitySpearManagerEx;
import net.lrsoft.mets.entity.EntityGunBullet;
import net.lrsoft.mets.entity.EntityHyperGunBullet;
import net.lrsoft.mets.entity.EntityPlasmaBullet;
import net.lrsoft.mets.entity.EntityRocket;
import net.lrsoft.mets.entity.EntityTachyonBullet;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="mets")
public class EntityManager {
    private static int currentEntityId = 0;

    @SubscribeEvent
    public static void onEntityInit(RegistryEvent.Register<EntityEntry> event) {
        EntityManager.registerEntity(event, EntityGunBullet.class, "GunBullet", 200, 5);
        EntityManager.registerEntity(event, EntityHyperGunBullet.class, "HyperGunBullet", 250, 5);
        EntityManager.registerEntity(event, EntityRocket.class, "RocketBullet", 200, 3);
        EntityManager.registerEntity(event, EntityPlasmaBullet.class, "PlasmaBullet", 200, 5);
        EntityManager.registerEntity(event, EntityTachyonBullet.class, "TachyonBullet", 300, 5);
        if (Loader.isModLoaded((String)"flammpfeil.slashblade")) {
            EntityManager.registerEntity(event, EntitySlashDimensionEx.class, "EntitySlashDimensionEx", 400, 1);
            EntityManager.registerEntity(event, EntityDriveEx.class, "EntityDriveEx", 400, 1);
            EntityManager.registerEntity(event, EntitySpearManagerEx.class, "EntitySpearManagerEx", 400, 1);
        }
    }

    private static void registerEntity(RegistryEvent.Register<EntityEntry> event, Class<? extends Entity> entityClass, String entityName, int updateRange, int updateFrequency) {
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(entityClass).id(new ResourceLocation("mets", entityName), currentEntityId++).name(entityName).tracker(updateRange, updateFrequency, true).build());
    }
}

