/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.manager;

import ic2.api.recipe.IElectrolyzerRecipeManager;
import ic2.api.recipe.Recipes;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FluidManager {
    public static Fluid crudeOil = new Fluid("crude_oil", new ResourceLocation("mets", "fluids/crude_oil_still"), new ResourceLocation("mets", "fluids/crude_oil_flow")).setGaseous(false);
    public static Fluid dieselOil = new Fluid("diesel_oil", new ResourceLocation("mets", "fluids/diesel_oil_still"), new ResourceLocation("mets", "fluids/diesel_oil_flow")).setGaseous(false);
    public static BlockFluidClassic crudeOilBlock;
    public static BlockFluidClassic dieselOilBlock;

    public static void onFluidInit() {
        crudeOil = FluidManager.registerFluid(crudeOil);
        dieselOil = FluidManager.registerFluid(dieselOil);
    }

    public static void onFluidBlockInit(RegistryEvent.Register<Block> event) {
        crudeOilBlock = FluidManager.getFluidBlock(crudeOil);
        dieselOilBlock = FluidManager.getFluidBlock(dieselOil);
        event.getRegistry().register((IForgeRegistryEntry)crudeOilBlock);
        event.getRegistry().register((IForgeRegistryEntry)dieselOilBlock);
    }

    public static void onRecipeInit() {
        Recipes.electrolyzer.addRecipe(crudeOil.getName(), 300, 128, 50, new IElectrolyzerRecipeManager.ElectrolyzerOutput[]{new IElectrolyzerRecipeManager.ElectrolyzerOutput(dieselOil.getName(), 200, EnumFacing.NORTH)});
    }

    private static Fluid registerFluid(Fluid fluid) {
        if (!FluidRegistry.registerFluid((Fluid)fluid)) {
            return FluidRegistry.getFluid((String)fluid.getName());
        }
        return fluid;
    }

    public static BlockFluidClassic getFluidBlock(Fluid fluid) {
        BlockFluidClassic blockFluidClassic = new BlockFluidClassic(fluid, Material.field_151586_h);
        blockFluidClassic.setRegistryName(fluid.getName());
        blockFluidClassic.func_149663_c(fluid.getName());
        blockFluidClassic.func_149647_a(null);
        return blockFluidClassic;
    }
}

