/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.manager;

import java.util.Random;
import net.lrsoft.mets.manager.BlockManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenManager
implements IWorldGenerator {
    private WorldGenMinable niobiumOre = new WorldGenMinable(BlockManager.niobiumOre.func_176223_P(), 3);
    private WorldGenMinable titaniumOre = new WorldGenMinable(BlockManager.titaniumOre.func_176223_P(), 4);

    private static void runGenerator(WorldGenMinable normalore, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Invalid height");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunk_Z * 16 + rand.nextInt(16);
            normalore.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 1: {
                break;
            }
            case -1: {
                break;
            }
            default: {
                WorldGenManager.runGenerator(this.niobiumOre, world, random, chunkX, chunkZ, 15, 0, 75);
                WorldGenManager.runGenerator(this.titaniumOre, world, random, chunkX, chunkZ, 18, 0, 75);
            }
        }
    }
}

