/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.renderer;

import java.util.Random;
import java.util.Vector;
import net.lrsoft.mets.entity.EntityPlasmaBullet;
import net.lrsoft.mets.renderer.particle.XCustomizedParticle;
import net.lrsoft.mets.util.MathUtils;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class PlasmaBulletRenderer
extends Render<EntityPlasmaBullet> {
    private Vector<XCustomizedParticle> particleVector = new Vector();

    public PlasmaBulletRenderer(RenderManager manager) {
        super(manager);
    }

    public void doRender(EntityPlasmaBullet entity, double x, double y, double z, float entityYaw, float partialTicks) {
        XCustomizedParticle particle;
        for (int i = 0; i < this.particleVector.size(); ++i) {
            particle = this.particleVector.get(i);
            particle.onRender(partialTicks);
            if (!particle.getIsFinish()) continue;
            this.particleVector.remove(i);
        }
        for (int count = 0; count < 24; ++count) {
            particle = new XCustomizedParticle(new Vec3d((double)0.8f, 1.0, 1.0), new Vec3d(x, y, z), new Vec3d(this.getNewMotion(entity.field_70159_w), this.getNewMotion(entity.field_70181_x), this.getNewMotion(entity.field_70179_y)), new Vec3d((double)0.1f, (double)0.1f, (double)0.1f), new Vec3d(0.0, 0.0, 1.0), 0.0f, MathUtils.getRandomFromRange(20, 5));
            this.particleVector.add(particle);
        }
    }

    private double getNewMotion(double motion) {
        double value = motion;
        if (new Random().nextInt() % 2 == 0) {
            value *= MathUtils.getRandomFromRange(0.1, 0.01);
            value /= 12.0;
        } else {
            value *= MathUtils.getRandomFromRange(-0.01, -0.1);
            value /= 12.0;
        }
        return value;
    }

    protected ResourceLocation getEntityTexture(EntityPlasmaBullet entity) {
        return null;
    }
}

